// SQLExpress driver for iSeries Access
//  2001-2005 Peter Sawatzki (peter@sawatzki.de)
//
//

// BUILDFORDLL is used to build dbexpca400.dll


{$IfNDef BUILDFORDLL}

Unit DbExpCA400;
Interface
Implementation
Uses
	Classes, SysUtils, WideStrings, WideStrUtils, Windows,
	FMTBCD,
	DbXpress,
//{$If RTLVersion>=18.00}
	DbCommonTypes,
//{$IfEnd}
	iSeriesAccess,
	SqlExpr;
{$else}
Library DbExpCA400;

uses
	Classes,
	SysUtils,
	WideStrings,
	WideStrUtils,
	Windows,
	FMTBCD,
	DbXpress,
	iSeriesAccess;

{$R dbexpca400.res} // version info
{$EndIf}

Const
	dbexpca400_ReleaseLevel: PChar = 'dbexpca400 v.3.0.01';

{$If RTLVersion<=15.00}
	DBXERR_NONE 									 = 0;
	DBXERR_INVALIDTXNID 					 = $0010;
{$IfEnd}
{$If RTLVersion<18.00}
	fldWIDESTRING 		 = 26;							{ UCS2 null terminated string }
{$ifend}
	DBXERR_CA400Error = 256;

	szTypeUnsupported = '(unsupported)';
	stCATALOG = 'CATALOG ';
	stNATIVE = 'NATIVE ';
	SpecialQualifier = '!'; // special Qualifier for stored procedures
	CommitmentLevel: Array[TTransIsolationLevel] Of Word =
	// xilREADCOMMITTED,			 xilREPEATABLEREAD, xilDIRTYREAD, xilCUSTOM)
		(CWBDB_CURSOR_STABILITY, CWBDB_ALL, 				CWBDB_NONE, 	CWBDB_CHANGE);
	CommitRetain: Array[Boolean] Of Word = (CWBDB_WORK, CWBDB_HOLD);
	szLIBL = '*LIBL';
	szUSRLIBL = '*USRLIBL';

	FlagPackedPos = $0F;	// $0C in ASCII mode
	FlagPackedNeg = $0D;	// $0D in ASCII mode
	FlagZonedPos	= $F0;	// $30 in ASCII mode
	FlagZonedNeg	= $D0;	// $70 in ASCII mode

Type
	ECA400InvalidConnection = Class(Exception);
	ECA400InvalidCommand = Class(Exception);
	TSmallIntArray = Array[0..16363] Of SmallInt;
	TColumnParam = Record
		Num: Word;
		Offset: Cardinal;
		isParam: Boolean;
		Name: WideString;

		// logical
		LogType: Word;
		LogSubType: Word;
		LogPrecision: SmallInt;
		LogScale: SmallInt;
		LogLength: Cardinal;
		Searchable: Boolean;					// columns only
		ParamType: TSTMTParamType;		// params only
		LogIsNull: Boolean; 					// params only
		LogCP: Cardinal;
		TypeName: WideString;

		// physical
		PhyType: SmallInt;
		PhyTypeAS400: SmallInt;
		Precision: Word;
		Scale: Word;
		PhyLength: Cardinal;
		PhyLOBLength: Cardinal; 			// columns only ?
		PhyDir: Word; 								// params only
		PhyCP: Cardinal;

		// LOB related, stored here for convenience
		LOBhandle: cwbDB_DataHandle;
		LOBdata: Pointer;
		LOBlength: Cardinal;
	End;
	TColumnParams = Array Of TColumnParam;

	TRequestType = (rtSQL, rtCatalog, rtNative);

	TAS400NumericData = Array[0..31] Of Byte;

	// the following record definition was copied from SqlExpr post Delphi2005, for the DLL we do not want to include the whole unit
	pSQLTRACEDesc30 = ^SQLTRACEDesc30;
	SQLTRACEDesc30 = packed record						 { trace callback info }
		pszTrace				: array [0..1023] of WideChar;
		eTraceCat 			: TRACECat;
		ClientData			: Integer;
		uTotalMsgLen		: Word;
	end;

	// the following record definition was copied from SqlExpr, for the DLL we do not want to include the whole unit
	pSQLTRACEDesc25 = ^SQLTRACEDesc25;
	SQLTRACEDesc25 = packed record						 { trace callback info }
		pszTrace				: array [0..1023] of AnsiChar;
		eTraceCat 			: TRACECat;
		ClientData			: Integer;
		uTotalMsgLen		: Word;
	end;

	// the following definition was copied from FMTBcd, we do not want to include the whole unit and Variants etc.
	TInternalBcd	= packed record
		Precision: Byte;												{ 1..64 }
		SignSpecialPlaces: Byte;								{ Sign:1, Special:1, Places:6 }
		Fraction: packed array [0..31] of Byte; { BCD Nibbles, 00..99 per Byte, high Nibble 1st }
	end;

	// the following definition was copied froom SqlTimSt, we do no want to include the whole unit and Variants etc.
	TSQLTimeStamp = packed record
		Year: SmallInt;
		Month: Word;
		Day: Word;
		Hour: Word;
		Minute: Word;
		Second: Word;
		Fractions: LongWord;
	end;

	TCA400SQLDriver = class(TInterfacedObject, ISQLDriver)
	private
		FUseVersion: String;
	protected
		function getSQLConnection(out pConn: ISQLConnection): SQLResult; stdcall;
		function SetOption(eDOption: TSQLDriverOption; PropValue: LongInt): SQLResult; stdcall;
		function GetOption(eDOption: TSQLDriverOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult; stdcall;
	end;

	// forwards for implementation classes
	TCA400SQLConnection = class;
	TCA400SQLCommand = class;
	TCA400SQLCursor = class;
	TCA400SQLMetaData = class;

	{$if RTLVersion >= 18.00}
	TCA400SQLConnection30 = class(TInterfacedObject, ISQLConnection30)
	private
		FConnection: TCA400SQLConnection;
	protected
		function connect(): SQLResult; overload; stdcall;
		function connect(ServerName: PWideChar; UserName: PWideChar; Password: PWideChar): SQLResult; overload; stdcall;
		function disconnect: SQLResult; stdcall;
		function getSQLCommand(out pComm: ISQLCommand30): SQLResult; stdcall;
		function getSQLMetaData(out pMetaData: ISQLMetaData30): SQLResult; stdcall;
		function SetOption(eConnectOption: TSQLConnectionOption; lValue: LongInt): SQLResult; stdcall;
		function GetOption(eDOption: TSQLConnectionOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult; stdcall;
		function beginTransaction(TranID: LongWord): SQLResult; stdcall;
		function commit(TranID: LongWord): SQLResult; stdcall;
		function rollback(TranID: LongWord): SQLResult; stdcall;
		function getErrorMessage(Error: PWideChar): SQLResult; overload; stdcall;
		function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult; stdcall;
	public
		Constructor Create(AOwner: TCA400SqlDriver);
		Destructor Destroy; Override;
	end;

	TCA400SQLCommand30 = class(TInterfacedObject, ISQLCommand30)
	private
		FCommand: TCA400SQLCommand;
	protected
		function SetOption(eSqlCommandOption: TSQLCommandOption; ulValue: Integer): SQLResult; stdcall;
		function GetOption(eSqlCommandOption: TSQLCommandOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult; stdcall;
		function setParameter(ulParameter: Word; ulChildPos: Word; eParamType: TSTMTParamType ; uLogType: Word; uSubType: Word; iPrecision: Integer; iScale: Integer; Length: LongWord ; pBuffer: Pointer; lInd: Integer): SQLResult; stdcall;
		function getParameter(ParameterNumber: Word; ulChildPos: Word; Value: Pointer; Length: Integer; var IsBlank: Integer): SQLResult; stdcall;
		function prepare(SQL: PWideChar; ParamCount: Word): SQLResult; stdcall;
		function execute(var Cursor: ISQLCursor30): SQLResult; stdcall;
		function executeImmediate(SQL: PWideChar; var Cursor: ISQLCursor30): SQLResult; stdcall;
		function getNextCursor(var Cursor: ISQLCursor30): SQLResult; stdcall;
		function getRowsAffected(var Rows: LongWord): SQLResult; stdcall;
		function close: SQLResult; stdcall;
		function getErrorMessage(Error: PWideChar): SQLResult; overload; stdcall;
		function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult; stdcall;
	public
		constructor Create (AOwner: TCA400SqlConnection);
		destructor Destroy; Override;
	end;

	TCA400SQLCursor30 = class(TInterfacedObject, ISQLCursor30)
	private
		FCursor: TCA400SQLCursor;
	protected
	 function SetOption(eOption: TSQLCursorOption; PropValue: LongInt): SQLResult; stdcall;
	 function GetOption(eOption: TSQLCursorOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult; stdcall;
	 function getErrorMessage(Error: PWideChar): SQLResult; overload; stdcall;
	 function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult; stdcall;
	 function getColumnCount(var pColumns: Word): SQLResult; stdcall;
	 function getColumnNameLength(ColumnNumber: Word; var pLen: Word): SQLResult; stdcall;
	 function getColumnName(ColumnNumber: Word; pColumnName: PWideChar): SQLResult; stdcall;
	 function getColumnType(ColumnNumber: Word; var puType: Word; var puSubType: Word): SQLResult; stdcall;
	 function  getColumnLength(ColumnNumber: Word; var pLength: LongWord): SQLResult; stdcall;
	 function getColumnPrecision(ColumnNumber: Word; var piPrecision: SmallInt): SQLResult; stdcall;
	 function getColumnScale(ColumnNumber: Word; var piScale: SmallInt): SQLResult; stdcall;
	 function isNullable(ColumnNumber: Word; var Nullable: LongBool): SQLResult; stdcall;
	 function isAutoIncrement(ColumnNumber: Word; var AutoIncr: LongBool): SQLResult; stdcall;
	 function isReadOnly(ColumnNumber: Word; var ReadOnly: LongBool): SQLResult; stdcall;
	 function isSearchable(ColumnNumber: Word; var Searchable: LongBool): SQLResult; stdcall;
	 function isBlobSizeExact(ColumnNumber: Word; var IsExact: LongBool): SQLResult; stdcall;
	 function next: SQLResult; stdcall;
	 function getString(ColumnNumber: Word; Value: PChar; var IsBlank: LongBool): SQLResult; stdcall;
	 function getWideString(ColumnNumber: Word; Value: PWideChar; var IsBlank: LongBool): SQLResult; stdcall;
	 function getShort(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
	 function getLong(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
	 function getInt64(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
	 function getDouble(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
	 function getBcd(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
	 function getTimeStamp(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
	 function getTime(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
	 function getDate(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
	 function getBytes(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
	 function getBlobSize(ColumnNumber: Word; var Length: LongWord; var IsBlank: LongBool): SQLResult; stdcall;
	 function getBlob(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool; Length: LongWord): SQLResult; stdcall;
	public
		constructor Create (ACursor: TCA400SqlCursor);
		destructor Destroy; Override;
	end;

	TCA400SQLMetaData30 = class(TInterfacedObject, ISQLMetadata30)
	private
		FMetaData: TCA400SQLMetaData;
	protected
		function SetOption(eDOption: TSQLMetaDataOption; PropValue: LongInt): SQLResult; stdcall;
		function GetOption(eDOption: TSQLMetaDataOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult; stdcall;
		function getObjectList(eObjType: TSQLObjectType; out Cursor: ISQLCursor30): SQLResult; stdcall;
		function getTables(TableName: PWideChar; TableType: LongWord; out Cursor: ISQLCursor30): SQLResult; stdcall;
		function getProcedures(ProcedureName: PWideChar; ProcType: LongWord; out Cursor: ISQLCursor30): SQLResult; stdcall;
		function getColumns(TableName: PWideChar; ColumnName: PWideChar; ColType: LongWord; Out Cursor: ISQLCursor30): SQLResult; stdcall;
		function getProcedureParams(ProcName: PWideChar; ParamName: PWideChar; out Cursor: ISQLCursor30): SQLResult; stdcall;
		function getIndices(TableName: PWideChar; IndexType: LongWord; out Cursor: ISQLCursor30): SQLResult; stdcall;
		function getErrorMessage(Error: PWideChar): SQLResult; overload; stdcall;
		function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult; stdcall;
	public
		constructor Create (AOwner: TCA400SqlConnection);
		destructor Destroy; Override;
	end;

	{$else}
	// for earlier version compatability
	ISQLConnection25 = ISQLConnection;
	ISQLCommand25 	 = ISQLCommand;
	ISQLCursor25		 = ISQLCursor;
	ISQLMetaData25	 = ISQLMetaData;
	{$ifend}

	TCA400SQLConnection25 = class(TInterfacedObject, ISQLConnection25)
	private
		FConnection: TCA400SQLConnection;
	protected
		function connect(ServerName: PChar; UserName: PChar; Password: PChar): SQLResult; stdcall;
		function disconnect: SQLResult; stdcall;
		function getSQLCommand(out pComm: ISQLCommand25): SQLResult; stdcall;
		function getSQLMetaData(out pMetaData: ISQLMetaData25): SQLResult; stdcall;
		function SetOption(eConnectOption: TSQLConnectionOption; lValue: LongInt): SQLResult; stdcall;
		function GetOption(eDOption: TSQLConnectionOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult; stdcall;
		function beginTransaction(TranID: LongWord): SQLResult; stdcall;
		function commit(TranID: LongWord): SQLResult; stdcall;
		function rollback(TranID: LongWord): SQLResult; stdcall;
		function getErrorMessage(Error: PChar): SQLResult; overload; stdcall;
		function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult; stdcall;
	public
		Constructor Create(AOwner: TCA400SqlDriver);
		Destructor Destroy; Override;
	end;

	TCA400SQLCommand25 = class(TInterfacedObject, ISQLCommand25)
	private
		FCommand: TCA400SQLCommand;
	protected
		function SetOption(eSqlCommandOption: TSQLCommandOption; ulValue: Integer): SQLResult; stdcall;
		function GetOption(eSqlCommandOption: TSQLCommandOption; {$IfDef VER140} var pValue: Integer; {$Else} pValue: Pointer; {$EndIf} MaxLength: SmallInt; out Length: SmallInt): SQLResult; stdcall;
		function setParameter(ulParameter: Word; ulChildPos: Word; eParamType: TSTMTParamType; uLogType: Word; uSubType: Word; iPrecision: Integer; iScale: Integer; iLen: LongWord; pBuffer: Pointer; lInd: Integer): SQLResult; stdcall;
		function getParameter(ParameterNumber: Word; ulChildPos: Word; Value: Pointer; Length: Integer; var IsBlank: Integer): SQLResult; stdcall;
		function prepare(SQL: PChar; ParamCount: Word): SQLResult; overload; stdcall;
		function execute(var Cursor: ISQLCursor25): SQLResult; stdcall;
		function executeImmediate(SQL: PChar; var Cursor: ISQLCursor25): SQLResult; overload; stdcall;
		function getNextCursor(var Cursor: ISQLCursor25): SQLResult; stdcall;
		function getRowsAffected(var Rows: LongWord): SQLResult; stdcall;
		function close: SQLResult; stdcall;
		function getErrorMessage(Error: PChar): SQLResult; overload; stdcall;
		function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult; stdcall;
	public
		constructor Create (AOwner: TCA400SqlConnection);
		destructor Destroy; Override;
	end;

	TCA400SQLCursor25 = class(TInterfacedObject, ISQLCursor25)
	private
		FCursor: TCA400SQLCursor;
	protected
		function SetOption(eOption: TSQLCursorOption; PropValue: LongInt): SQLResult; stdcall;
		function GetOption(eOption: TSQLCursorOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult; stdcall;
		function getErrorMessage(Error: PChar): SQLResult; overload; stdcall;
		function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult; stdcall;
		function getColumnCount(var pColumns: Word): SQLResult; stdcall;
		function getColumnNameLength(ColumnNumber: Word; var pLen: Word): SQLResult; stdcall;
		function getColumnName(ColumnNumber: Word; pColumnName: PChar): SQLResult; stdcall;
		function getColumnType(ColumnNumber: Word; var puType: Word; var puSubType: Word): SQLResult; stdcall;
		function	getColumnLength(ColumnNumber: Word; var pLength: LongWord): SQLResult; stdcall;
		function getColumnPrecision(ColumnNumber: Word; var piPrecision: SmallInt): SQLResult; stdcall;
		function getColumnScale(ColumnNumber: Word; var piScale: SmallInt): SQLResult; stdcall;
		function isNullable(ColumnNumber: Word; var Nullable: LongBool): SQLResult; stdcall;
		function isAutoIncrement(ColumnNumber: Word; var AutoIncr: LongBool): SQLResult; stdcall;
		function isReadOnly(ColumnNumber: Word; var ReadOnly: LongBool): SQLResult; stdcall;
		function isSearchable(ColumnNumber: Word; var Searchable: LongBool): SQLResult; stdcall;
		function isBlobSizeExact(ColumnNumber: Word; var IsExact: LongBool): SQLResult; stdcall;
		function next: SQLResult; stdcall;
		function getString(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
		function getShort(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
		function getLong(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
		function getDouble(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
		function getBcd(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
		function getTimeStamp(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
		function getTime(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
		function getDate(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
		function getBytes(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; stdcall;
		function getBlobSize(ColumnNumber: Word; var Length: LongWord; var IsBlank: LongBool): SQLResult; stdcall;
		function getBlob(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool; Length: LongWord): SQLResult; stdcall;
	public
		constructor Create (ACursor: TCA400SqlCursor);
		destructor Destroy; Override;
	end;

	TCA400SQLMetaData25 = class(TInterfacedObject, ISQLMetadata25)
	private
		FMetaData: TCA400SQLMetaData;
	protected
		function SetOption(eDOption: TSQLMetaDataOption; PropValue: LongInt): SQLResult; stdcall;
		function GetOption(eDOption: TSQLMetaDataOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult; stdcall;
		function getObjectList(eObjType: TSQLObjectType; out Cursor: ISQLCursor25): SQLResult; stdcall;
		function getTables(TableName: PChar; TableType: LongWord; out Cursor: ISQLCursor25): SQLResult; stdcall;
		function getProcedures(ProcedureName: PChar; ProcType: LongWord; out Cursor: ISQLCursor25): SQLResult; stdcall;
		function getColumns(TableName: PChar; ColumnName: PChar; ColType: LongWord; Out Cursor: ISQLCursor25): SQLResult; stdcall;
		function getProcedureParams(ProcName: PChar; ParamName: PChar; out Cursor: ISQLCursor25): SQLResult; stdcall;
		function getIndices(TableName: PChar; IndexType: LongWord; out Cursor: ISQLCursor25): SQLResult; stdcall;
		function getErrorMessage(Error: PChar): SQLResult; overload; stdcall;
		function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult; stdcall;
	public
		constructor Create (AOwner: TCA400SqlConnection);
		destructor Destroy; Override;
	end;

	// implementation classes
	TCA400SQLConnection = class
	Private
		FDriver: TCA400SQLDriver;
		FExpectWide: Boolean; // is data already wide?
		FErrorHandler: TcwbDBErrorHandler;
		securityHandle: cwbSY_SecurityHandle;
		sysHandle: cwbCO_SysHandle;
		connectionHandle: cwbDB_ConnectionHandle;
		commitHandle: cwbDB_RequestHandle;
		FSQLCommands: TList;
		FBlobSize: Integer;
		WError: String;
		FLOBThreshold: Integer;
		FCallBack: Pointer;
		FCBInfo: Integer;
		FTransIsoLevel: TTransIsolationLevel;
		FAutoCommit: Boolean;
		FCommitRetain: Boolean;
		FCurrentTransaction: LongWord;
		FHostCCSID: Cardinal; // for informational purposes only (yet?)
		FTimeOut: Integer;
		FTrimChar: Boolean;
		// Options
		FFullQuoting: Boolean;					 // full quoting
		FSystemNaming: Boolean;
		FDescribeOption: Integer;
		FMapFloat: Boolean;
		FInt64AsBCD: Boolean;
		FReuseStatementName: Boolean;
		FLibs: TStrings;
		FLIMITMD: Integer;
		FTraceLevel: Integer;
		FSortType: Integer;

		WHostName: WideString; // not used
		WServerLevel: WideString;
		WSortTable: WideString;
		WSortLib: WideString;
		WRole: WideString;
		WUser: WideString;
		WPassword: WideString;
		WServerName: WideString;

		// other
		FId: Integer; // unique id that gets incremented for every query to prepare

		WCatalogName: WideString;
		WConnectionString: WideString;
		WSchemaName, WObjectName: WideString; // for quoting support

		FHostCP, FClientCP: Cardinal; // overrides
		Function GetErrHandle: cwbSV_ErrHandle;
		function GetQualifier: WideChar;
		Procedure SetServerCharSet (Value: WideString);
		Function RetrieveLIBL (Value: WideString): WideString;
		Procedure ExpandLibs;
	Protected
		// implementation of ISQLConnection methods
		Function connect: SQLResult;
		Function disconnect: SQLResult;
		Function SetOption(eConnectOption: TSQLConnectionOption; lValue: LongInt): SQLResult;
		Function GetOption(eDOption: TSQLConnectionOption; PropValue: Pointer; MaxLength: SmallInt; out Len: SmallInt): SQLResult;
		Function beginTransaction(TranID: LongWord): SQLResult;
		Function commit(TranID: LongWord): SQLResult;
		Function rollback(TranID: LongWord): SQLResult;
		Function getErrorMessage: WideString;
		Function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
		// end ISQLConnection methods

		Procedure SetConfigOptions(Value: WideString);
		Procedure ParseOptions(Value: WideString);
		Function GetQualifiedName(Quoted: Boolean): WideString;
		Function Trace (Const Value: WideString; Reason: TSQLTraceFlag = traceMISC): Boolean; Overload;
		Function Trace (Const Value: WideString; Items: Array Of Const; Reason: TSQLTraceFlag = traceMISC): Boolean; Overload;
	Public
		Constructor Create(AOwner: TCA400SqlDriver);
		Destructor Destroy; Override;
		Property errHandle: cwbSV_ErrHandle Read GetErrHandle;
		Property ErrorHandler: TcwbDBErrorHandler Read FErrorHandler;
		Property Libs: TStrings Read FLibs;
		Property Qualifier: WideChar Read GetQualifier;
	End;

	TCA400SQLCommand = class
	Private
		FConnection: TCA400SQLConnection;
		FErrorHandler: TcwbDBErrorHandler;
		requestHandle: cwbDB_RequestHandle;
		dataHandle: cwbDB_DataHandle;
		indicatorHandle: cwbDB_DataHandle;
		outputDataHandle: cwbDB_DataHandle;
		outputIndicatorHandle: cwbDB_DataHandle;
		formatHandle: cwbDB_FormatHandle;
		pmFormatHandle: cwbDB_FormatHandle;
		FrequestType: TRequestType; 	// rtSQL normally
		FCurrentCursorName: String;
		FQuery: String;

		indicatorBuffer: Pointer; 	// signed shorts
		dataBuffer: pChar;
		pmindicatorBuffer: Pointer; // signed shorts
		pmdataBuffer: pChar;
		outputIndicatorBuffer: Pointer; // signed shorts
		outputDataBuffer: pChar;

		uColumns: Cardinal;
		uParams: Cardinal;

		FBlobSize: Integer;
		FBlockCount: Integer;
		FIsStoredProc: Boolean;
		FCursorOpen: Boolean;

		Cols: TColumnParams;
		Params: TColumnParams;

		// row stuff
		rowsDataBuffer: pChar;							// pointer to fetched rows
		rowsIndicatorBuffer: Pointer; 			// signed shorts
		rowSize: Cardinal;									// size of one row
		rowSizeIndicator: Cardinal; 				// size of one row of indicators
		rowCount: Cardinal; 								// count of rows read
		curRow: Cardinal; 									// current row
		rowsaffected: Integer;
		resultSets: Integer;								// resultsets left
		bufferFilled: Boolean;

		FDirectQuery: Boolean;							// is this a query that will not be re-executed ?

		Function GetConn: TCA400SQLConnection;
		function GetErrHandle: cwbSV_ErrHandle;
		function GetSize(getType: Word; Var Item: TColumnParam; var Len: LongWord; var IsBlank: LongBool): SQLResult;
		procedure ReleaseLobHandles;
	Protected
		// implementation of ISQLCommand methods
		Function SetOption(eSqlCommandOption: TSQLCommandOption; ulValue: Integer): SQLResult;
		Function GetOption(eSqlCommandOption: TSQLCommandOption; {$IfDef VER140} var pValue: Integer; {$Else} pValue: Pointer; {$EndIf} MaxLength: SmallInt; out Length: SmallInt): SQLResult;
		Function setParameter(ulParameter: Word; ulChildPos: Word; eParamType: TSTMTParamType; uLogType: Word; uSubType: Word; iPrecision: Integer; iScale: Integer; iLen: LongWord; pBuffer: Pointer; lInd: Integer): SQLResult;
		Function getParameter(ParameterNumber: Word; ulChildPos: Word; Value: Pointer; Length: Integer; var IsBlank: Integer): SQLResult;
		Function prepare(SQL: WideString; ParamCount: Word): SQLResult;
		Function Execute(var Cursor: TCA400SQLCursor): SQLResult;
		Function executeImmediate(SQL: PWideChar; var Cursor: TCA400SQLCursor): SQLResult;
		Function getNextCursor(var Cursor: TCA400SQLCursor): SQLResult;
		Function getRowsAffected(var Rows: LongWord): SQLResult;
		Function close: SQLResult;
		Function getErrorMessage: WideString;
		Function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
		// end ISQLCommand methods

		// BDP
		Function bdpGetParameter(ParameterNumber, ulChildPos: Word; VarType: Word; Value: Pointer; Length: Integer; var IsBlank: Integer): SQLResult;

		Function PrepareSQL (ParamCount: Word): SQLResult;
		Function PrepareCatalog: SQLResult;
		Function PrepareNative: SQLResult;
		Procedure describeColumns;
		Procedure describeParameters;
		Function fetch: SQLResult;
		Function fetchRows: SQLResult;
		Function fetchBlob(Var Item: TColumnParam; locator: Cardinal): SQLResult;
		Function GetData(getType: Word; Var Item: TColumnParam; Value: Pointer; Var IsBlank: LongBool): SQLResult;
		Procedure setLogicalTypeInfo (Var Value: TColumnParam);
		Procedure ReleaseResources;
		Procedure Open;
		Function Trace (Const Value: String): Boolean; Overload;
		Function Trace (Const Value: String; Items: Array Of Const): Boolean; Overload;

		// data conversion
		Function ZonedToDouble (Const data: TAS400NumericData; Scale, Width: Integer): Double;
		Function PackedToDouble (Const data: TAS400NumericData; Scale, Width: Integer): Double;
		Function ZonedToInt (Const data: TAS400NumericData; Scale, Width: Integer): Integer;
		Function PackedToInt (Const data: TAS400NumericData; Scale, Width: Integer): Integer;
		Function ZonedToInt64 (Const data: TAS400NumericData; Scale, Width: Integer): Int64;
		Function PackedToInt64 (Const data: TAS400NumericData; Scale, Width: Integer): Int64;
		Procedure DoubleToZoned (Value: Double; Var data: TAS400NumericData; Scale, Width: Integer);
		Procedure DoubleToPacked (Value: Double; Var data: TAS400NumericData; Scale, Width: Integer);
		Procedure IntToZoned (Value: Integer; Var data: TAS400NumericData; Width: Integer);
		Procedure IntToPacked (Value: Integer; Var data: TAS400NumericData; Width: Integer);
		Procedure Int64ToZoned (Value: Int64; Var data: TAS400NumericData; Width: Integer);
		Procedure Int64ToPacked (Value: Int64; Var data: TAS400NumericData; Width: Integer);
		procedure Int64ToBcd(Value: Int64; var Bcd: TInternalBcd; Precision: Byte);
		Procedure ZonedToBcd (Const data: TAS400NumericData; scale, width: Integer; Var Bcd: TInternalBcd; Precision: Byte);
		Procedure PackedToBcd (Const data: TAS400NumericData; scale, width: Integer; Var Bcd: TInternalBcd; Precision: Byte);
		Procedure BcdToZoned (Const Bcd: TInternalBcd; Var data: TAS400NumericData; scale, width: Integer);
		Procedure BcdToPacked (Const Bcd: TInternalBcd; Var data: TAS400NumericData; scale, width: Integer);
		Function BcdToInt64 (Const Bcd: TInternalBcd): Int64;
		Function DateTimeToAS400 (Value: TSqlTimeStamp): String;
		Function DateToAS400 (Value: SQLDate): String;
		Function TimeToAS400 (Value: SQLTime): String;
		function AS400ToDateTime(Value: String): TSqlTimeStamp;
		function AS400ToDate(Value: String): SQLDate;
		function AS400ToTime(Value: String): SQLTime;
		function IntToInt(Value: Integer): Integer;
		function WordToWord(Value: Word): Word;
		function SingleToSingle(Value: Single): Single;
		function DoubleToDouble(Value: Double): Double;
		function BigToBig(Value: INT64): INT64;
	Public
		Constructor Create (AOwner: TCA400SqlConnection);
		Destructor Destroy; Override;
		Property Conn: TCA400SQLConnection Read GetConn;
		Property errHandle: cwbSV_ErrHandle Read GetErrHandle;
		Property ErrorHandler: TcwbDBErrorHandler Read FErrorHandler;
		Property ColumnCount: Cardinal Read uColumns;
	End;

	TCA400SQLCursor = class
	Private
		FCommand: TCA400SQLCommand;
		function GetCommand: TCA400SQLCommand;
		function GetCols: TColumnParams;
		function GetConn: TCA400SQLConnection;
	Protected
		// implementation of ISQLCursor methods
		Function SetOption(eOption: TSQLCursorOption; PropValue: LongInt): SQLResult;
		Function GetOption(eOption: TSQLCursorOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
		Function getErrorMessage: WideString;
		Function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
		Function getColumnCount(var pColumns: Word): SQLResult;
		Function getColumnNameLength(ColumnNumber: Word; var pLen: Word): SQLResult;
		Function getColumnName(ColumnNumber: Word; pColumnName: PWideChar): SQLResult; overload;
		Function getColumnType(ColumnNumber: Word; var puType: Word; var puSubType: Word): SQLResult;
		Function getColumnLength(ColumnNumber: Word; var pLength: LongWord): SQLResult;
		Function getColumnPrecision(ColumnNumber: Word; var piPrecision: SmallInt): SQLResult;
		Function getColumnScale(ColumnNumber: Word; var piScale: SmallInt): SQLResult;
		Function isNullable(ColumnNumber: Word; var Nullable: LongBool): SQLResult;
		Function isAutoIncrement(ColumnNumber: Word; var AutoIncr: LongBool): SQLResult;
		Function isReadOnly(ColumnNumber: Word; var ReadOnly: LongBool): SQLResult;
		Function isSearchable(ColumnNumber: Word; var Searchable: LongBool): SQLResult;
		Function isBlobSizeExact(ColumnNumber: Word; var IsExact: LongBool): SQLResult;
		Function next: SQLResult;
{$if RTLVersion>=18.00}
		Function getString(ColumnNumber: Word; Value: PChar; var IsBlank: LongBool): SQLResult; overload;
{$else}
		Function getString(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult; overload;
{$ifend}
		Function getWideString(ColumnNumber: Word; Value: PWideChar; var IsBlank: LongBool): SQLResult;
		Function getShort(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
		Function getLong(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
		Function getInt64(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
		Function getDouble(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
		Function getBcd(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
		Function getTimeStamp(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
		Function getTime(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
		Function getDate(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
		Function getBytes(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
		Function getBlobSize(ColumnNumber: Word; var Length: LongWord; var IsBlank: LongBool): SQLResult;
		Function getBlob(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool; Length: LongWord): SQLResult;
		// end ISQLCursor methods
	Public
		Constructor Create(AOwner: TCA400SqlCommand); Virtual;
		Destructor Destroy; Override;
		Function CheckColumn(Var Res: SQLResult; Index: Word): Boolean;
		Property Command: TCA400SQLCommand Read GetCommand;
		Property Conn: TCA400SQLConnection Read GetConn;
		Property Cols: TColumnParams Read GetCols;
	End;

	{ Metadata }

	TCA400SQLMetaDataCursor = Class;

	TCA400SQLMetaData = Class(TInterfacedObject, ISQLMetaData)
	Private
		FConnection: TCA400SQLConnection;
		FMDCursor: TCA400SQLMetaDataCursor; // hack for BDP
		WMetaCatalogName, WMetaSchemaName: WideString;
		{$If RTLVersion >= 15.00} WMetaPackageName: WideString; {$IfEnd}
		WMetaDatabaseName: WideString;
		function GetConn: TCA400SQLConnection;
		function ExpandSchemas(const Value: WideString): WideString;
		procedure AddQueryItem(Var Q: WideString; Tag, Value: WideString);
		procedure AddInStr(var S: WideString; const Value: WideString);
		Function CreateCase(Topic, Value: WideString): WideString;
		Function ExecuteQuery(Value: WideString; Const Columns: Array Of WideString; MaxRec: Integer = 0): SQLResult;
	Protected
		// implementation of ISQLMetaData methods
		Function SetOption(eDOption: TSQLMetaDataOption; PropValue: LongInt): SQLResult;
		Function GetOption(eDOption: TSQLMetaDataOption; PropValue: Pointer; MaxLength: SmallInt; out Len: SmallInt): SQLResult;
		Function getObjectList(eObjType: TSQLObjectType): SQLResult;
		Function getErrorMessage: WideString;
		Function getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
		// end ISQLmetaData methods
	Public
		Constructor Create(AOwner: TCA400SqlConnection);
		Destructor Destroy; Override;
		// new methods for BDP
		Function GetTables(CatalogName, OwnerName, ObjectName: PWideChar; TableType: LongWord): SQLResult;
		Function GetColumns(CatalogName, OwnerName, TableName, ColumnName: PWideChar; ColType: LongWord): SQLResult;
		Function GetIndices(CatalogName, OwnerName, TableName: PWideChar; IndexType: LongWord): SQLResult;
		Function GetProcedures(CatalogName, OwnerName, ProcedureName: PWideChar; ProcType: LongWord): SQLResult;
		Function getProcedureParams(CatalogName, OwnerName, ProcName: PWideChar; ParamName: PWideChar): SQLResult;
		// end new methods
		Property Conn: TCA400SQLConnection Read GetConn;
		Property MDCursor: TCA400SQLMetaDataCursor Read FMDCursor;
	End;

	TCA400SQLMetaDataCursor = class(TCA400SQLCursor)
	Private
		FRecNo: Integer;
		FMaxRec: Integer;
		FSchemaColumn, FObjColumn: Integer;
		FDataTypeColumn, FTypeNameColumn, FSubTypeColumn, FPrecisionColumn, FScaleColumn: Integer;
		FOrdColumn: Integer;
		FOrd: Integer;
		WDefaultSchema: WideString;
	Protected
		// implementation of ISQLCursor methods
		Function next: SQLResult;
		Function getLong(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
		Function getWideString(ColumnNumber: Word; Value: PWideChar; var IsBlank: LongBool): SQLResult;
		Function getString(ColumnNumber: Word; Value: PChar; var IsBlank: LongBool): SQLResult;
		// end ISQLCursor methods
	 Procedure MapDataType (TypeName: WideString; Precision, Scale: Integer; Var DataType, SubType: Word);
	 Function getTypeSubType(Var DataType, SubType: Word; Var IsBlank: LongBool): SQLResult;
	Public
		Destructor Destroy; Override;
	End;


{ Utility functions }
function MapException (Value: Exception; AObject: TObject): SQLResult;
var
	Conn: TCA400SQLConnection;
begin
	// preliminary implementation
	Result:= DBXERR_CA400Error;
	If Value Is ECA400InvalidConnection Then
		Result:= DBXERR_INVALIDHNDL
	Else If Value Is ECA400InvalidCommand Then
		Result:= DBXERR_INVALIDHNDL
	Else If Value Is EOutOfMemory Then
		Result:= DBXERR_NOMEMORY;
	if AObject<>nil then
	begin
		Conn:= nil;
{$if RTLVersion>=18.00}
		if AObject is TCA400SQLConnection30 then
			Conn:= (AObject as TCA400SQLConnection30).FConnection
		else
		if AObject is TCA400SQLCommand30 then
			Conn:= (AObject as TCA400SQLCommand30).FCommand.FConnection
		else
		if AObject is TCA400SQLCursor30 then
			Conn:= (AObject as TCA400SQLCursor30).FCursor.FCommand.FConnection
		else
		if AObject is TCA400SQLMetaData30 then
			Conn:= (AObject as TCA400SQLMetaData30).FMetaData.FConnection
		else
{$ifend}
		if AObject is TCA400SQLConnection25 then
			Conn:= (AObject as TCA400SQLConnection25).FConnection
		else
		if AObject is TCA400SQLCommand25 then
			Conn:= (AObject as TCA400SQLCommand25).FCommand.FConnection
		else
		if AObject is TCA400SQLCursor25 then
			Conn:= (AObject as TCA400SQLCursor25).FCursor.FCommand.FConnection
		else
		if AObject is TCA400SQLMetaData25 then
			Conn:= (AObject as TCA400SQLMetaData25).FMetaData.FConnection;

		if Conn<>nil then
			Conn.WError:= Value.Message;
	end;
	// map DBXERR_INVALIDUSRPASS for cwbSY_Logon

	// DBXERR_NOMEMORY
	// DBXERR_INVALIDFLDTYPE
	// DBXERR_INVALIDHNDL
	// DBXERR_INVALIDTIME
	// DBXERR_NOTSUPPORTED
	// DBXERR_INVALIDXLATION
	// DBXERR_INVALIDPARAM
	// DBXERR_OUTOFRANGE
	// DBXERR_SQLPARAMNOTSET
	// DBXERR_EOF
	// DBXERR_INVALIDUSRPASS
	// DBXERR_INVALIDPRECISION
	// DBXERR_INVALIDLEN
	// DBXERR_DUPLICATETXNID
	// DBXERR_DRIVERRESTRICTED
End;

Function Min (A,B: Integer): Integer;
Begin
	If A<B Then Result:= A Else Result:= B
End;

Function Overflow (Value: Int64; Bits: Integer): Boolean;
Begin
	If Bits=16 Then
		Result:= (Value<-32768) Or (Value>32767)
	Else If Bits=32 Then
		Result:= (Value<-Int64(2147483648)) Or (Value>2147483647)
	Else
		Result:= False
End;

Function Cite (Const Value: WideString): WideString;
Begin
	Result:= Trim(Value);
	If (Result<>'') And (Result[1]<>'''') Then
		Result:= ''''+Result+''''
End;

// unquote and uppercase if necessary (if previously NOT quoted)
Function Unquote (Const Value: WideString): WideString;
Var
	L,P: Integer;
Begin
	Result:= Trim(Value);
	L:= Length(Result);
	If (L>1) And ((Result[1]='"') Or (Result[L]='"')) then
	begin
		P:= 1;
		if Result[L]='"' then
			Dec(L);
		if Result[1]='"' then
		begin
			Inc(P);
			Dec(L)
		end;
		Result:= Copy(Result, P, L)
	end
	else
		Result:= WideUpperCase(Result)
End;

Procedure RetrieveSchemaObject (Const Value: WideString; Var Schema, Obj: WideString);
// retrieve schema and object from fully qualified value (schema.obj or "schema"."obj")
// schema and object are returned unquoted and uppercased if neccessary (if they were
// previously NOT quoted)
Var
	p: Integer;
Begin
	p:= Pos('.', Value);
	If p=0 Then p:= Pos('/', Value);
	If p=0 Then p:= Pos(SpecialQualifier, Value);
	If p=0 Then Begin
		Schema:= '';
		Obj:= Unquote(Value)
	End Else Begin
		Schema:= Unquote(Copy(Value, 1, p-1));
		Obj:= Unquote(Copy(Value, p+1, Length(Value)))
	End
End;

// Trim and Clean up SQL for iSeries, for example DB2/400 has a problem
// with CR/LF in the query
Function CleanSQL (Const Value: WideString): WideString;
Begin
	Result:= Trim(WideStringReplace(Value, #13#10, ' ', [rfReplaceAll]))
End;

{ Interface classes }

{ TCA400SQLDriver }

function TCA400SQLDriver.getSQLConnection(out pConn: ISQLConnection): SQLResult;
begin try
	pConn:= Nil;
	// the below ISQLConnectionXX(<obj create>) casts before the assignment make
	// sure that the proper interface is copied - really important stuff!!!
	{$if RTLVersion >= 18.00 }
	if FUseVersion=DBXPRODUCTVERSION30 then
		pConn:= ISQLConnection30(TCA400SqlConnection30.Create(Self)) // the cast to ISQLConnection30 ensures that the proper Interface is copied
	else
	{$ifend}
		pConn:= ISQLConnection25(TCA400SqlConnection25.Create(Self)); // the cast to ISQLConnection25 ensures that the proper Interface is copied
	Result:= DBXERR_NONE;
except
	Result:= DBXERR_NOMEMORY
end end;

Function TCA400SQLDriver.GetOption(eDOption: TSQLDriverOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
	Procedure SetStr (Const Value: String);
	Begin
		if (MaxLength>0) and (PropValue<>Nil) then
			StrLCopy(PropValue, PChar(Value), MaxLength);
		Length:= System.Length(Value)
	End;
Begin Try
	Result:= DBXERR_NONE;
	Case eDOption Of
		eDrvRestrict: ; // no restrictions
		{$if RTLVersion >= 18.00 }
		eDrvVersion: SetStr(DBXDRIVERVERSION30);
		{$ifend}
	Else
		Result:= DBXERR_NOTSUPPORTED
	End
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function TCA400SQLDriver.SetOption(eDOption: TSQLDriverOption; PropValue: LongInt): SQLResult;
Begin Try
	Result:= DBXERR_NONE;
	Case eDOption Of
		eDrvRestrict: ;
		{$if RTLVersion >= 18.00 }
		eDrvProductVersion: FUseVersion:= PChar(PropValue);
		{$ifend}
	Else
		Result:= DBXERR_NOTSUPPORTED
	End
Except
	Result:= DBXERR_INVALIDHNDL
End End;

{ TCA400SQLConnection25 }

constructor TCA400SQLConnection25.Create(AOwner: TCA400SqlDriver);
begin
	inherited Create;
	FConnection:= TCA400SQLConnection.Create(AOwner);
end;

destructor TCA400SQLConnection25.Destroy;
begin
	FConnection.Free;
	inherited;
end;

function TCA400SQLConnection25.getSQLCommand(out pComm: ISQLCommand25): SQLResult;
Begin Try
	pComm:= TCA400SQLCommand25.Create(FConnection);
	Result:= DBXERR_NONE
Except On E: Exception Do Result:= MapException(E, Self)
End End;

function TCA400SQLConnection25.getSQLMetaData(out pMetaData: ISQLMetaData25): SQLResult;
begin try
	pMetaData:= TCA400SQLMetaData25.Create(FConnection);
	Result:= DBXERR_NONE
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection25.connect(ServerName, UserName, Password: PChar): SQLResult;
begin try
	FConnection.WUser:= UserName;
	FConnection.WPassword:= Password;
	FConnection.WServerName:= ServerName;
	Result:= FConnection.Connect
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection25.SetOption(eConnectOption: TSQLConnectionOption; lValue: Integer): SQLResult;
begin try
	Result:= FConnection.SetOption(eConnectOption, lValue)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection25.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin try
	Result:= FConnection.getErrorMessageLen(ErrorLen);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection25.disconnect: SQLResult;
begin try
	Result:= FConnection.disconnect;
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection25.getErrorMessage(Error: PChar): SQLResult;
begin try
	StrCopy(Error, PAnsiChar(AnsiString(FConnection.getErrorMessage)));
	Result:= DBXERR_NONE
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection25.commit(TranID: LongWord): SQLResult;
begin try
	Result:= FConnection.commit(TranID);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection25.beginTransaction(TranID: LongWord): SQLResult;
begin try
	Result:= FConnection.beginTransaction(TranID);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection25.GetOption(eDOption: TSQLConnectionOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
begin try
	Result:= FConnection.GetOption(eDOption, PropValue, MaxLength, Length);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection25.rollback(TranID: LongWord): SQLResult;
begin try
	Result:= FCOnnection.rollback(TranID);
except on E: Exception Do Result:= MapException(E, Self)
end end;

{ TCA400SQLConnection30 }

{$if RTLVersion >= 18.0 }
constructor TCA400SQLConnection30.Create(AOwner: TCA400SqlDriver);
begin
	inherited Create;
	FConnection:= TCA400SQLConnection.Create(AOwner);
	FConnection.FExpectWide:= true;
end;

destructor TCA400SQLConnection30.Destroy;
begin
	FConnection.Free;
	inherited;
end;

function TCA400SQLConnection30.getSQLCommand(out pComm: ISQLCommand30): SQLResult;
Begin Try
	pComm:= TCA400SQLCommand30.Create(FConnection);
	Result:= DBXERR_NONE
Except On E: Exception Do Result:= MapException(E, Self)
End End;

function TCA400SQLConnection30.getSQLMetaData(out pMetaData: ISQLMetaData30): SQLResult;
begin try
	pMetaData:= TCA400SQLMetaData30.Create(FConnection);
	Result:= DBXERR_NONE
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection30.connect(ServerName, UserName, Password: PWideChar): SQLResult;
begin try
	FConnection.WUser:= UserName;
	FConnection.WPassword:= Password;
	FConnection.WServerName:= ServerName;
	Result:= FConnection.Connect
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection30.connect: SQLResult;
begin try
	Result:= FConnection.connect;
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection30.SetOption(eConnectOption: TSQLConnectionOption; lValue: Integer): SQLResult;
begin try
	Result:= FConnection.SetOption(eConnectOption, lValue)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection30.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin try
	Result:= FConnection.getErrorMessageLen(ErrorLen)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection30.disconnect: SQLResult;
begin try
	Result:= FConnection.disconnect
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection30.getErrorMessage(Error: PWideChar): SQLResult;
begin try
	WStrPCopy(Error, FConnection.getErrorMessage);
	Result:= DBXERR_NONE
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection30.commit(TranID: LongWord): SQLResult;
begin try
	Result:= FConnection.commit(TranID);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection30.beginTransaction(TranID: LongWord): SQLResult;
begin try
	Result:= FConnection.beginTransaction(TranID);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection30.GetOption(eDOption: TSQLConnectionOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
begin try
	Result:= FConnection.GetOption(eDOption, PropValue, MaxLength, Length);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLConnection30.rollback(TranID: LongWord): SQLResult;
begin try
	Result:= FConnection.rollback(TranID)
except on E: Exception Do Result:= MapException(E, Self)
end end;

{$ifend}

{ TCA400SQLCommand25 }

constructor TCA400SQLCommand25.Create(AOwner: TCA400SqlConnection);
begin
	inherited Create;
	FCommand:= TCA400SQLCommand.Create(AOwner);
end;

destructor TCA400SQLCommand25.Destroy;
begin
	FCommand.Free;
	inherited;
end;

function TCA400SQLCommand25.getNextCursor(var Cursor: ISQLCursor25): SQLResult;
var
	ACursor: TCA400SQLCursor;
begin try
	Cursor:= nil;
	Result:= FCommand.GetNextCursor(ACursor);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor25.Create(ACursor)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.prepare(SQL: PChar; ParamCount: Word): SQLResult;
begin try
	Result:= FCommand.prepare(SQL, ParamCount);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.SetOption(eSqlCommandOption: TSQLCommandOption; ulValue: Integer): SQLResult;
begin try
	Result:= FCommand.SetOption(eSqlCommandOption, ulValue)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin try
	Result:= FCommand.getErrorMessageLen(ErrorLen)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.getParameter(ParameterNumber, ulChildPos: Word;  Value: Pointer; Length: Integer; var IsBlank: Integer): SQLResult;
begin try
	Result:= FCommand.getParameter(ParameterNumber, ulChildPos, Value, Length, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.getRowsAffected(var Rows: LongWord): SQLResult;
begin try
	Result:= FCommand.getRowsAffected(Rows)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.getErrorMessage(Error: PChar): SQLResult;
begin try
	StrCopy(Error, PAnsiChar(AnsiString(FCommand.getErrorMessage)));
	Result:= DBXERR_NONE
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.close: SQLResult;
begin try
	Result:= FCommand.close
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.GetOption(eSqlCommandOption: TSQLCommandOption; pValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
begin try
	Result:= FCommand.GetOption(eSqlCommandOption, pValue, MaxLength, Length);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.setParameter(ulParameter, ulChildPos: Word; eParamType: TSTMTParamType; uLogType, uSubType: Word; iPrecision, iScale: Integer; iLen: LongWord; pBuffer: Pointer; lInd: Integer): SQLResult;
begin try
	Result:= FCommand.setParameter(ulParameter, ulChildPos, eParamType, uLogType, uSubType, iPrecision, iScale, iLen, pBuffer, lInd);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.executeImmediate(SQL: PChar; var Cursor: ISQLCursor25): SQLResult;
var
	ACursor: TCA400SQLCursor;
	WS: WideString;
begin try
	Cursor:= nil;
	WS:= SQL;
	Result:= FCommand.ExecuteImmediate(PWideChar(WS), ACursor);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor25.Create(ACursor)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand25.execute(var Cursor: ISQLCursor25): SQLResult;
var
	ACursor: TCA400SQLCursor;
begin try
	Cursor:= nil;
	Result:= FCommand.Execute(ACursor);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor25.Create(ACursor)
except on E: Exception Do Result:= MapException(E, Self)
end end;

{ TCA400SQLCommand30 }

{$if RTLVersion >= 18.0 }
constructor TCA400SQLCommand30.Create(AOwner: TCA400SqlConnection);
begin
	inherited Create;
	FCommand:= TCA400SQLCommand.Create(AOwner);
end;

destructor TCA400SQLCommand30.Destroy;
begin
	FCommand.Free;
	inherited;
end;

function TCA400SQLCommand30.getNextCursor(var Cursor: ISQLCursor30): SQLResult;
var
	ACursor: TCA400SQLCursor;
begin try
	Cursor:= nil;
	Result:= FCommand.GetNextCursor(ACursor);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor30.Create(ACursor)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.prepare(SQL: PWideChar; ParamCount: Word): SQLResult;
begin try
	Result:= FCommand.prepare(SQL, ParamCount);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.SetOption(eSqlCommandOption: TSQLCommandOption; ulValue: Integer): SQLResult;
begin try
	Result:= FCommand.SetOption(eSqlCommandOption, ulValue);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin try
	Result:= FCommand.getErrorMessageLen(ErrorLen)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.getParameter(ParameterNumber, ulChildPos: Word; Value: Pointer; Length: Integer; var IsBlank: Integer): SQLResult;
begin try
	Result:= FCommand.getParameter(ParameterNumber, ulChildPos, Value, Length, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.getRowsAffected(var Rows: LongWord): SQLResult;
begin try
	Result:= FCommand.getRowsAffected(Rows)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.getErrorMessage(Error: PWideChar): SQLResult;
begin try
	WStrPCopy(Error, FCommand.getErrorMessage);
	Result:= DBXERR_NONE
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.close: SQLResult;
begin try
	Result:= FCommand.close
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.GetOption(eSqlCommandOption: TSQLCommandOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
begin try
	Result:= FCommand.GetOption(eSqlCommandOption, PropValue, MaxLength, Length);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.setParameter(ulParameter, ulChildPos: Word;  eParamType: TSTMTParamType; uLogType, uSubType: Word; iPrecision,	iScale: Integer; Length: LongWord; pBuffer: Pointer;	lInd: Integer): SQLResult;
begin try
	Result:= FCommand.setParameter(ulParameter, ulChildPos, eParamType, uLogType, uSubType, iPrecision, iScale, Length, pBuffer, lInd);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.executeImmediate(SQL: PWideChar;	var Cursor: ISQLCursor30): SQLResult;
var
	ACursor: TCA400SQLCursor;
begin try
	Cursor:= nil;
	Result:= FCommand.ExecuteImmediate(SQL, ACursor);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor30.Create(ACursor)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCommand30.execute(var Cursor: ISQLCursor30): SQLResult;
var
	ACursor: TCA400SQLCursor;
begin try
	Cursor:= nil;
	Result:= FCommand.Execute(ACursor);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor30.Create(ACursor)
except on E: Exception Do Result:= MapException(E, Self)
end end;
{$ifend}

{ TCA400SQLCursor25 }

constructor TCA400SQLCursor25.Create(ACursor: TCA400SqlCursor);
begin
	inherited Create;
	FCursor:= ACursor
end;

destructor TCA400SQLCursor25.Destroy;
begin
	FCursor.Free;
	inherited;
end;

function TCA400SQLCursor25.getBcd(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getBcd(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getBlob(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool; Length: LongWord): SQLResult;
begin try
	Result:= FCursor.getBlob(ColumnNumber, Value, IsBlank, Length)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getBlobSize(ColumnNumber: Word; var Length: LongWord; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getBlobSize(ColumnNumber, Length, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getBytes(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getBytes(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getColumnCount(var pColumns: Word): SQLResult;
begin try
	Result:= FCursor.getColumnCount(pColumns)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getColumnLength(ColumnNumber: Word; var pLength: LongWord): SQLResult;
begin try
	Result:= FCursor.getColumnLength(ColumnNumber, pLength)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getColumnName(ColumnNumber: Word; pColumnName: PChar): SQLResult;
var
	WBuffer: Array[0..128] Of WideChar;
begin try
	Result:= FCursor.getColumnName(ColumnNumber, WBuffer);
	if Result=DBXERR_NONE then
		StrCopy(pColumnName, PChar(String(WBuffer)));
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getColumnNameLength(ColumnNumber: Word; var pLen: Word): SQLResult;
begin try
	Result:= FCursor.getColumnNameLength(ColumnNumber, pLen)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getColumnPrecision(ColumnNumber: Word; var piPrecision: SmallInt): SQLResult;
begin try
	Result:= FCursor.getColumnPrecision(ColumnNumber, piPrecision)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getColumnScale(ColumnNumber: Word; var piScale: SmallInt): SQLResult;
begin try
	Result:= FCursor.getColumnScale(ColumnNumber, piScale)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getColumnType(ColumnNumber: Word; var puType, puSubType: Word): SQLResult;
begin try
	Result:= FCursor.getColumnType(ColumnNumber, puType, puSubType)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getDate(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getDate(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getDouble(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getDouble(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getErrorMessage(Error: PChar): SQLResult;
begin try
	StrCopy(Error, PAnsiChar(AnsiString(FCursor.getErrorMessage)));
	Result:= DBXERR_NONE
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin try
	Result:= FCursor.getErrorMessageLen(ErrorLen)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getLong(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getLong(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.GetOption(eOption: TSQLCursorOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
begin try
	Result:= FCursor.getOption(eOption, PropValue, MaxLength, Length)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getShort(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getShort(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getString(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getString(ColumnNumber, PChar(Value), IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getTime(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getTime(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.getTimeStamp(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getTimeStamp(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.isAutoIncrement(ColumnNumber: Word; var AutoIncr: LongBool): SQLResult;
begin try
	Result:= FCursor.isAutoIncrement(ColumnNumber, AutoIncr)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.isBlobSizeExact(ColumnNumber: Word; var IsExact: LongBool): SQLResult;
begin try
	Result:= FCursor.isBlobSizeExact(ColumnNumber, IsExact)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor25.isNullable(ColumnNumber: Word; var Nullable: LongBool): SQLResult;
Begin Try
	Result:= FCursor.isNullable(ColumnNumber, Nullable)
Except On E: Exception Do Result:= MapException(E, Self)
End End;

function TCA400SQLCursor25.isReadOnly(ColumnNumber: Word; var ReadOnly: LongBool): SQLResult;
Begin Try
	Result:= FCursor.isReadOnly(ColumnNumber, ReadOnly)
Except On E: Exception Do Result:= MapException(E, Self)
End End;

function TCA400SQLCursor25.isSearchable(ColumnNumber: Word; var Searchable: LongBool): SQLResult;
Begin Try
	Result:= FCursor.isSearchable(ColumnNumber, Searchable)
Except On E: Exception Do Result:= MapException(E, Self)
End End;

function TCA400SQLCursor25.next: SQLResult;
Begin Try
	Result:= FCursor.next
Except On E: Exception Do Result:= MapException(E, Self)
End End;

function TCA400SQLCursor25.SetOption(eOption: TSQLCursorOption; PropValue: Integer): SQLResult;
Begin Try
	Result:= FCursor.SetOption(eOption, PropValue)
Except On E: Exception Do Result:= MapException(E, Self)
End End;

{ TCA400SQLCursor30 }

{$if RTLVersion >= 18.0 }
constructor TCA400SQLCursor30.Create(ACursor: TCA400SqlCursor);
begin
	inherited Create;
	FCursor:= ACursor;
end;

destructor TCA400SQLCursor30.Destroy;
begin
	FCursor.Free;
	inherited;
end;

function TCA400SQLCursor30.getBcd(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getBcd(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getBlob(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool; Length: LongWord): SQLResult;
begin try
	Result:= FCursor.getBlob(ColumnNumber, Value, IsBlank, Length)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getBlobSize(ColumnNumber: Word; var Length: LongWord; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getBlobSize(ColumnNumber, Length, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getBytes(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getBytes(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getColumnCount(var pColumns: Word): SQLResult;
begin try
	Result:= FCursor.getColumnCount(pColumns)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getColumnLength(ColumnNumber: Word; var pLength: LongWord): SQLResult;
begin try
	Result:= FCursor.getColumnLength(ColumnNumber, pLength)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getColumnName(ColumnNumber: Word; pColumnName: PWideChar): SQLResult;
begin try
	Result:= FCursor.getColumnName(ColumnNumber, pColumnName)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getColumnNameLength(ColumnNumber: Word; var pLen: Word): SQLResult;
begin try
	Result:= FCursor.getColumnNameLength(ColumnNumber, pLen)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getColumnPrecision(ColumnNumber: Word; var piPrecision: SmallInt): SQLResult;
begin try
	Result:= FCursor.getColumnPrecision(ColumnNumber, piPrecision)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getColumnScale(ColumnNumber: Word; var piScale: SmallInt): SQLResult;
begin try
	Result:= FCursor.getColumnScale(ColumnNumber, piScale)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getColumnType(ColumnNumber: Word; var puType, puSubType: Word): SQLResult;
begin try
	Result:= FCursor.getColumnType(ColumnNumber, puType, puSubType)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getDate(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getDate(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getDouble(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getDouble(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getErrorMessage(Error: PWideChar): SQLResult;
begin try
	WStrPCopy(Error, FCursor.getErrorMessage);
	Result:= DBXERR_NONE
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin try
	Result:= FCursor.getErrorMessageLen(ErrorLen)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getLong(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getLong(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.GetOption(eOption: TSQLCursorOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
begin try
	Result:= FCursor.getOption(eOption, PropValue, MaxLength, Length)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getShort(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getShort(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getString(ColumnNumber: Word; Value: PChar; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getString(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getInt64(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getInt64(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getWideString(ColumnNumber: Word; Value: PWideChar; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getWideString(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getTime(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getTime(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.getTimeStamp(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin try
	Result:= FCursor.getTimeStamp(ColumnNumber, Value, IsBlank)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.isAutoIncrement(ColumnNumber: Word; var AutoIncr: LongBool): SQLResult;
begin try
	Result:= FCursor.isAutoIncrement(ColumnNumber, AutoIncr)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.isBlobSizeExact(ColumnNumber: Word; var IsExact: LongBool): SQLResult;
begin try
	Result:= FCursor.isBlobSizeExact(ColumnNumber, IsExact)
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLCursor30.isNullable(ColumnNumber: Word; var Nullable: LongBool): SQLResult;
Begin Try
	Result:= FCursor.isNullable(ColumnNumber, Nullable)
Except On E: Exception Do Result:= MapException(E, Self)
End End;

function TCA400SQLCursor30.isReadOnly(ColumnNumber: Word; var ReadOnly: LongBool): SQLResult;
Begin Try
	Result:= FCursor.isReadOnly(ColumnNumber, ReadOnly)
Except On E: Exception Do Result:= MapException(E, Self)
End End;

function TCA400SQLCursor30.isSearchable(ColumnNumber: Word; var Searchable: LongBool): SQLResult;
Begin Try
	Result:= FCursor.isSearchable(ColumnNumber, Searchable)
Except On E: Exception Do Result:= MapException(E, Self)
End End;

function TCA400SQLCursor30.next: SQLResult;
Begin Try
	Result:= FCursor.next
Except On E: Exception Do Result:= MapException(E, Self)
End End;

function TCA400SQLCursor30.SetOption(eOption: TSQLCursorOption; PropValue: Integer): SQLResult;
Begin Try
	Result:= FCursor.SetOption(eOption, PropValue)
Except On E: Exception Do Result:= MapException(E, Self)
End End;

{$ifend}

{ TCA400SQLMetaData25 }

constructor TCA400SQLMetaData25.Create(AOwner: TCA400SqlConnection);
begin
	inherited Create;
	FMetaData:= TCA400SQLMetaData.Create(AOwner);
end;

destructor TCA400SQLMetaData25.Destroy;
begin
	FMetaData.Free;
	inherited;
end;

function TCA400SQLMetaData25.getColumns(TableName, ColumnName: PChar; ColType: LongWord; out Cursor: ISQLCursor25): SQLResult;
Var
	SchemaSpec, TableSpec, ColSpec: WideString;
begin try
	Cursor:= Nil;
	RetrieveSchemaObject(TableName, SchemaSpec, TableSpec);
	ColSpec:= ColumnName;
	Result:= FMetaData.GetColumns('', PWideChar(SchemaSpec), PWideChar(TableSpec), PWideChar(ColSpec), ColType);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor25.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData25.getErrorMessage(Error: PChar): SQLResult;
begin try
	StrCopy(Error, PAnsiChar(AnsiString(FMetaData.getErrorMessage)));
	Result:= DBXERR_NONE
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData25.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin try
	Result:= FMetaData.getErrorMessageLen(ErrorLen);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData25.getIndices(TableName: PChar; IndexType: LongWord; out Cursor: ISQLCursor25): SQLResult;
Var
	SchemaSpec, TableSpec: WideString;
begin try
	Cursor:= Nil;
	RetrieveSchemaObject(TableName, SchemaSpec, TableSpec);
	Result:= FMetaData.GetIndices('', PWideChar(SchemaSpec), PWideChar(TableSpec), 7 {IndexType});
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor25.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData25.getObjectList(eObjType: TSQLObjectType; out Cursor: ISQLCursor25): SQLResult;
begin try
	Cursor:= Nil;
	Result:= FMetaData.getObjectList(eObjType);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor25.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData25.GetOption(eDOption: TSQLMetaDataOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
begin try
	Result:= FMetaData.GetOption(eDOption, PropValue, MaxLength, Length);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData25.getProcedureParams(ProcName, ParamName: PChar; out Cursor: ISQLCursor25): SQLResult;
Var
	SchemaSpec, ProcSpec, WParamName: WideString;
begin try
	Cursor:= Nil;
	RetrieveSchemaObject(ProcName, SchemaSpec, ProcSpec);
	WParamName:= ParamName;
	Result:= FMetaData.GetProcedureParams('', PWideChar(SchemaSpec), PWideChar(ProcSpec), PWideChar(WParamName));
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor25.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData25.getProcedures(ProcedureName: PChar; ProcType: LongWord; out Cursor: ISQLCursor25): SQLResult;
Var
	SchemaSpec, ProcSpec: WideString;
begin try
	Cursor:= Nil;
	RetrieveSchemaObject(ProcedureName, SchemaSpec, ProcSpec);
	Result:= FMetaData.GetProcedures('', PWideChar(SchemaSpec), PWideChar(ProcSpec), ProcType);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor25.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData25.getTables(TableName: PChar; TableType: LongWord; out Cursor: ISQLCursor25): SQLResult;
Var
	SchemaSpec, TableSpec: WideString;
begin try
	Cursor:= Nil;
	RetrieveSchemaObject(TableName, SchemaSpec, TableSpec);
	Result:= FMetaData.GetTables('', PWideChar(SchemaSpec), PWideChar(TableSpec), TableType);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor25.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData25.SetOption(eDOption: TSQLMetaDataOption; PropValue: Integer): SQLResult;
begin try
	Result:= FMetaData.SetOption(eDOption, PropValue);
except on E: Exception Do Result:= MapException(E, Self)
end end;

{ TCA400SQLMetaData30 }

{$if RTLVersion >= 18.0 }
constructor TCA400SQLMetaData30.Create(AOwner: TCA400SqlConnection);
begin
	inherited Create;
	FMetaData:= TCA400SQLMetaData.Create(AOwner);
end;

destructor TCA400SQLMetaData30.Destroy;
begin
	FMetaData.Free;
	inherited;
end;

function TCA400SQLMetaData30.getColumns(TableName, ColumnName: PWideChar; ColType: LongWord; out Cursor: ISQLCursor30): SQLResult;
Var
	SchemaSpec, TableSpec: WideString;
begin try
	Cursor:= Nil;
	RetrieveSchemaObject(TableName, SchemaSpec, TableSpec);
	Result:= FMetaData.GetColumns('', PWideChar(SchemaSpec), PWideChar(TableSpec), ColumnName, ColType);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor30.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData30.getErrorMessage(Error: PWideChar): SQLResult;
begin try
	WStrPCopy(Error, FMetaData.getErrorMessage);
	Result:= DBXERR_NONE
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData30.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin try
	Result:= FMetaData.getErrorMessageLen(ErrorLen);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData30.getIndices(TableName: PWideChar; IndexType: LongWord; out Cursor: ISQLCursor30): SQLResult;
Var
	SchemaSpec, TableSpec: WideString;
begin try
	Cursor:= Nil;
	RetrieveSchemaObject(TableName, SchemaSpec, TableSpec);
	Result:= FMetaData.GetIndices('', PWideChar(SchemaSpec), PWideChar(TableSpec), 7 {IndexType});
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor30.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData30.getObjectList(eObjType: TSQLObjectType; out Cursor: ISQLCursor30): SQLResult;
begin try
	Cursor:= Nil;
	Result:= FMetaData.getObjectList(eObjType);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor30.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData30.GetOption(eDOption: TSQLMetaDataOption; PropValue: Pointer; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
begin try
	Result:= FMetaData.GetOption(eDOption, PropValue, MaxLength, Length);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData30.getProcedureParams(ProcName, ParamName: PWideChar; out Cursor: ISQLCursor30): SQLResult;
Var
	SchemaSpec, ProcSpec: WideString;
begin try
	Cursor:= Nil;
	RetrieveSchemaObject(ProcName, SchemaSpec, ProcSpec);
	Result:= FMetaData.GetProcedureParams('', PWideChar(SchemaSpec), PWideChar(ProcSpec), ParamName);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor30.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData30.getProcedures(ProcedureName: PWideChar; ProcType: LongWord; out Cursor: ISQLCursor30): SQLResult;
Var
	SchemaSpec, ProcSpec: WideString;
begin try
	Cursor:= Nil;
	RetrieveSchemaObject(ProcedureName, SchemaSpec, ProcSpec);
	Result:= FMetaData.GetProcedures('', PWideChar(SchemaSpec), PWideChar(ProcSpec), ProcType);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor30.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData30.getTables(TableName: PWideChar; TableType: LongWord; out Cursor: ISQLCursor30): SQLResult;
Var
	SchemaSpec, TableSpec: WideString;
begin try
	Cursor:= Nil;
	RetrieveSchemaObject(TableName, SchemaSpec, TableSpec);
	Result:= FMetaData.GetTables('', PWideChar(SchemaSpec), PWideChar(TableSpec), TableType);
	if Result=DBXERR_NONE then
		Cursor:= TCA400SQLCursor30.Create(FMetaData.MDCursor);
except on E: Exception Do Result:= MapException(E, Self)
end end;

function TCA400SQLMetaData30.SetOption(eDOption: TSQLMetaDataOption; PropValue: Integer): SQLResult;
begin try
	Result:= FMetaData.SetOption(eDOption, PropValue);
except on E: Exception Do Result:= MapException(E, Self)
end end;
{$ifend}

{ Implementation Classes }

{ TCA400SQLConnection }

constructor TCA400SQLConnection.Create(AOwner: TCA400SqlDriver);
begin
	Inherited Create;
	FDriver:= AOwner;
	FSQLCommands:= TList.Create;
	FTransIsoLevel:= xilDirtyRead; // CWBDB_NONE
	FAutoCommit:= True;
	FCommitRetain:= True; // CWBDB_HOLD
	FBlobSize:= -1;
	FLOBThreshold:= -1;
	FTimeOut:= -1;
	FLIMITMD:= 300;
	FSortType:= -1; // leave sort to what is defined for the job/user
	WSortTable:= 'ENU';
	WSortLib:= '';
	FLibs:= TStringList.Create;
end;

destructor TCA400SQLConnection.Destroy;
begin
	FSQLCommands.Free;
	Libs.Free;
	inherited;
end;

function TCA400SQLConnection.connect: SQLResult;
Const
	NamingConvention: Array[Boolean] Of Word = (CWBDB_PERIOD_NAME_CONV, CWBDB_SLASH_NAME_CONV);
	AutoCommit: Array[Boolean] Of Word = (CWBDB_NO_AUTO_COMMIT, CWBDB_AUTO_COMMIT);
Var
	ClientCCSID: Cardinal;
	szServerLevel: Array[0..63] Of Char;
	WBuffer: Array[0..127] Of WideChar;
	lenBuffer: Cardinal;
begin
	FErrorHandler:= TcwbDBErrorHandler.Create;

	if WServerName='*' then
	begin
		FillChar(WBuffer, SizeOf(WBuffer), 0);
		lenBuffer:= Length(WBuffer)-1;
		if cwbCO_GetDefaultSysNameW(WBuffer, SizeOf(WBuffer), lenBuffer, errHandle)=CWB_OK then
			WServerName:= Trim(WBuffer)
	end;

	if cwbCO_CreateSystemW(PWideChar(WServerName), sysHandle)=cwb_OK then
	begin
		if WUser<>'' then begin
			cwbCO_SetUserIDExW(sysHandle, PWideChar(WUser), ErrorHandler);
			cwbCO_SetPasswordW(sysHandle, PWideChar(WPassword), ErrorHandler);
			cwbCO_SetPromptMode(sysHandle, CWBCO_PROMPT_NEVER, ErrorHandler);
		end;
		cwbCO_Connect(sysHandle, CWBCO_SERVICE_DATABASE, errHandle, ErrorHandler);
		cwbDB_CreateConnectionHandleEx(sysHandle, connectionHandle, errHandle, ErrorHandler);
		if WUser='' then
		begin
			FillChar(WBuffer, SizeOf(WBuffer), 0);
			lenBuffer:= Length(WBuffer)-1;
			If cwbCO_GetUserIDExW(sysHandle, WBuffer, lenBuffer)=CWB_OK Then
				WUser:= Trim(WBuffer)
		end
	end
	else
	begin
		cwbSY_CreateSecurityObj(securityHandle, ErrorHandler);
		cwbSY_SetSysW(securityHandle, PWideChar(WServerName), ErrorHandler);
		if WUser<>'' then
			cwbSY_LogonUserW(securityHandle, PWideChar(WUser), PWideChar(WPassword), errHandle, ErrorHandler);
		cwbDB_CreateConnectionHandleW(PWideChar(WServerName), connectionHandle, errHandle, ErrorHandler);
		if WUser='' Then Begin
			FillChar(WBuffer, SizeOf(WBuffer), 0);
			if cwbSY_GetUserIDW(securityHandle, PWideChar(WServerName), WBuffer)=CWB_OK Then
				WUser:= Trim(WBuffer)
		end
	end;
	cwbNL_GetHostCCSIDW(PWideChar(WServerName), FHostCCSID);

	If FSortType>=0 Then // set NL sort sequence
		cwbDB_SetNLSSW(connectionHandle, FSortType, PWideChar(WSortTable), PWideChar(WSortLib), errHandle, ErrorHandler);

	If FClientCP=0 Then
		cwbNL_GetANSICodePage (FClientCP, errHandle, ErrorHandler);
	cwbNL_CodePageToCCSID (FClientCP, ClientCCSID, errHandle, ErrorHandler);
	cwbDB_SetClientDataCCSID(connectionHandle, ClientCCSID, errHandle, ErrorHandler);
	cwbDB_SetClientHostErrorCCSID(connectionHandle, ClientCCSID, errHandle, ErrorHandler);
	cwbDB_SetClientInputCCSID(connectionHandle, ClientCCSID, errHandle, ErrorHandler);
	cwbDB_SetNamingConvention(connectionHandle, NamingConvention[FSystemNaming], errHandle);
	cwbDB_SetDateFormat(connectionHandle, CWBDB_DATE_FMT_ISO, errHandle);
	cwbDB_SetTimeFormat(connectionHandle, CWBDB_TIME_FMT_ISO, errHandle);
	cwbDB_SetCommitmentControl(connectionHandle, CommitmentLevel[FTransIsoLevel], errHandle);
	cwbDB_SetAutoCommit(connectionHandle, AutoCommit[FAutoCommit], errHandle);
	cwbDB_SetAmbiguousSelectOption(connectionHandle, CWBDB_READONLY, errHandle);

	// set LOB threshold for "inline" LOBs if BlobSize specified and release supports it
	if (FLOBThreshold>0) then
		cwbDB_SetLOBFieldThreshold(connectionHandle, FLOBThreshold, errHandle);

	If (WRole<>'') and (cwbDB_SetDefaultSQLLibraryNameW(connectionHandle, PWideChar(WRole), errHandle)<>CWB_OK) then
		Assert(Trace('Warning: set default SQL Library to %s failed', [WRole]));

	cwbDB_StartServer(connectionHandle, errHandle, ErrorHandler);
	If cwbDB_GetServerFunctionalLevel(connectionHandle, szServerLevel, errHandle)=cwb_Ok Then
		WServerLevel:= szServerLevel
	Else
		WServerLevel:= 'unknown';
	Assert(Trace('Server %s started, functional level %s', [WServerName, WServerLevel]));
	Assert(Trace('Client %s, %s, CP=%d CCSID=%d, Host CCSID=%d, connection %d', [cwbReleaseStr, dbexpca400_ReleaseLevel, FClientCP, ClientCCSID, FHostCCSID, connectionHandle]));

	// create dummy sql request handle for transaction support
	cwbDB_CreateSQLRequestHandle(connectionHandle, commitHandle, errHandle, ErrorHandler);
	// now do the *LIBL Expansion/Resolution for sysnaming or if requested via /libs=...
	ExpandLibs;
	Result:= DBXERR_NONE
end;

function TCA400SQLConnection.disconnect: SQLResult;
begin
	FCurrentTransaction:= 0;
	If commitHandle<>0 Then Begin
		cwbDB_DeleteSQLRequestHandle(commitHandle, errHandle, ErrorHandler);
		commitHandle:= 0
	End;
	If connectionHandle<>0 Then Begin
		cwbDB_StopServer(connectionHandle, errHandle, ErrorHandler);
		cwbDB_DeleteConnectionHandle(connectionHandle, errHandle, ErrorHandler);
		Assert(Trace('connection %d closed.', [connectionHandle]));
		connectionHandle:= 0
	End;
	FreeAndNil(FErrorHandler);
	If sysHandle<>0 Then Begin
		cwbCO_Disconnect(sysHandle, CWBCO_SERVICE_DATABASE, errHandle);
		cwbCO_DeleteSystem(sysHandle);
		sysHandle:= 0
	End;
	If securityHandle<>0 Then Begin
		cwbSY_DeleteSecurityObj(securityHandle);
		securityHandle:= 0
	End;
	Result:= DBXERR_NONE
end;

function TCA400SQLConnection.getErrorMessage: WideString;
begin
	Result:= WError;
	WError:= '';
end;

function TCA400SQLConnection.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin
	ErrorLen:= Length(WError);
	Result:= DBXERR_NONE
end;

Function TCA400SQLConnection.GetQualifiedName(Quoted: Boolean): WideString;
begin
	If Trim(WSchemaName)='' Then
		If Quoted Then
			Result:= WideFormat('"%s"', [WObjectName])
		Else
			Result:= WObjectName
	Else
		If Quoted Then
			Result:= WideFormat('"%s"."%s"', [WSchemaName, WObjectName])
		Else
			Result:= WideFormat('%s.%s', [WSchemaName, WObjectName])
end;

function TCA400SQLConnection.GetOption(eDOption: TSQLConnectionOption; PropValue: Pointer; MaxLength: SmallInt; out Len: SmallInt): SQLResult;
{$IfDef VER140} Const eConnMaxActiveComm = eConnMaxActiveConnection; {$EndIf}

	Procedure SetStr (Const Value: WideString);
	begin
		Len:= 0;
		if (MaxLength>0) and (PropValue<>Nil) then
			if FExpectWide then
			begin
				WStrLCopy(PropValue, PWideChar(Value), MaxLength div sizeof(widechar));
				Len:= WStrLen(PropValue)
			end
			else
			begin
				StrLCopy(PropValue, PAnsiChar(AnsiString(Value)), MaxLength);
				Len:= StrLen(PropValue)
			end
	end;

begin
	Result:= DBXERR_NONE;
	Case eDOption Of
		eConnServerVersion: SetStr(WServerLevel);
		eConnHostName:			SetStr(WHostName);
		eConnDatabaseName:	SetStr(WServerName);
		eConnBlobSize:			Integer(PropValue^):= FBlobSize;
		eConnNativeHandle:	Begin THandle(PropValue^):= connectionHandle; Len:= SizeOf(THandle) End;
		eConnMaxActiveComm: Integer(PropValue^):= 0;
		eConnRoleName:			SetStr(WRole);
		eConnTxnIsoLevel: 	Integer(PropValue^):= Integer(FTransIsoLevel);
		eConnAutoCommit:		Integer(PropValue^):= Integer(FAutoCommit);
		eConnCommitRetain:	Integer(PropValue^):= Integer(FCommitRetain);
{$If RTLVersion >= 15.00}
		eConnTimeOut: 				 Integer(PropValue^):= FTimeOut;
		eConnQuotedObjectName: SetStr(GetQualifiedName(True));
		eConnQualifiedName: 	 SetStr(GetQualifiedName(False));
		eConnCatalogName: 		 SetStr(WCatalogName);
		eConnSchemaName:			 SetStr(WSchemaName);
		eConnObjectName:			 SetStr(WObjectName);
{$IfEnd}
{$If RTLVersion >= 17.00}
		eConnConnectionString: SetStr(WConnectionString);
		// eConnTDSPacketSize:		;
		// eConnClientHostName: 	;
		// eConnClientAppName:		;
		// eConnCompressed: 			;
		// eConnEncrypted:				;
{$IfEnd}
	Else
		Result:= DBXERR_NOTSUPPORTED
	End
end;

function TCA400SQLConnection.SetOption(eConnectOption: TSQLConnectionOption; lValue: Integer): SQLResult;

	function GetStr: WideString;
	begin
		if FExpectWide then
			Result:= PWideChar(lValue)
		else
			Result:= AnsiString(PAnsiChar(lValue))
	end;

begin
	Result:= DBXERR_NONE;
	Case eConnectOption Of
		eConnHostName:			WHostName:= GetStr;
		eConnServerCharSet: SetServerCharSet(GetStr);
		eConnBlobSize:			FBlobSize:= lValue;
		eConnCallBack:			FCallBack:= Pointer(lValue);
		eConnCallBackInfo:	FCBInfo:= lValue;
		eConnRoleName:			SetConfigOptions(GetStr); // ROLENAME is misused to transport other options
		eConnTxnIsoLevel: 	FTransIsoLevel:= TTransIsolationLevel(lValue);
		eConnAutoCommit:		FAutoCommit:= Boolean(lValue);
		eConnCommitRetain:	FCommitRetain:= Boolean(lValue);
{$If RTLVersion >= 15.00}
		eConnTimeOut: 				 If (lValue=-1) Or (lValue>0) Then FTimeOut:= lValue;
		eConnQualifiedName: 	 RetrieveSchemaObject(GetStr, WSchemaName, WObjectName);
		eConnQuotedObjectName: RetrieveSchemaObject(GetStr, WSchemaName, WObjectName);
		eConnCatalogName: 		 WCatalogName:= Unquote(GetStr);
		eConnSchemaName:			 WSchemaName:= Unquote(GetStr);
		eConnObjectName:			 WObjectName:= Unquote(GetStr);
		eConnCustomInfo:			 ParseOptions(GetStr);
		eConnTrimChar:				 FTrimChar:= Boolean(lValue);
{$IfEnd}
{$If RTLVersion >= 17.00}
		eConnConnectionString: WConnectionString:= GetStr;
		// eConnTDSPacketSize:		;
		// eConnClientHostName: 	;
		// eConnClientAppName:		;
		// eConnCompressed: 			;
		// eConnEncrypted:				;
		// eConnPrepareSQL: 			;
		// eConnDecimalSeparator: ;
{$IfEnd}
	Else
		Result:= DBXERR_NOTSUPPORTED
	End
end;

function TCA400SQLConnection.beginTransaction(TranID: LongWord): SQLResult;
Var
	Trans: pTTransactionDesc;
begin
	Trans:= Pointer(TranID);
	If (FCurrentTransaction<>0) Or (Trans=Nil) Then Begin
		Result:= DBXERR_NOTSUPPORTED;
		Exit
	End;

	FCurrentTransaction:= Trans.TransactionID;
	Assert(Trace('beginTransaction %d', [FCurrentTransaction]));

	// set isolation level according to transaction if different
	{ // can not yet support this for D7 because D6 misbehaves
	If FTransIsoLevel<>Trans.IsolationLevel Then Begin
		cwbDB_SetCommitmentControl(connectionHandle, CommitmentLevel[Trans.IsolationLevel], errHandle, ErrorHandler);
		cwbDB_ApplyAttributes(connectionHandle, errHandle, ErrorHandler)
	End;
	}
	Result:= DBXERR_NONE
end;

function TCA400SQLConnection.commit(TranID: LongWord): SQLResult;
Var
	Trans: pTTransactionDesc;
begin
	Trans:= Pointer(TranID);
	If (FCurrentTransaction=0) Or (Trans=Nil) Then Begin
		Result:= DBXERR_NOTSUPPORTED;
		Exit
	End;
	If Trans.TransactionID<>FCurrentTransaction Then Begin
		Result:= DBXERR_INVALIDTXNID;
		Exit
	End;

	Assert(Trace('commit %d', [FCurrentTransaction]));
	// commit to the dummy request handle
	cwbDB_SetHoldIndicator(commitHandle, CommitRetain[FCommitRetain], errHandle, ErrorHandler);
	cwbDB_Commit(commitHandle, errHandle, ErrorHandler);

	FCurrentTransaction:= 0;

	// set isolation level back if different
	{ // can not yet support this for D7 because D6 misbehaves
	If FTransIsoLevel<>Trans.IsolationLevel Then Begin
		cwbDB_SetCommitmentControl(connectionHandle, CommitmentLevel[FTransIsoLevel], errHandle, ErrorHandler);
		cwbDB_ApplyAttributes(connectionHandle, errHandle, ErrorHandler)
	End;
	}
	Result:= DBXERR_NONE
end;

function TCA400SQLConnection.rollback(TranID: LongWord): SQLResult;
Var
	Trans: pTTransactionDesc;
begin
	Trans:= Pointer(TranID);
	If (FCurrentTransaction=0) Or (Trans=Nil) Then Begin
		Result:= DBXERR_NOTSUPPORTED;
		Exit
	End;
	If Trans.TransactionID<>FCurrentTransaction Then Begin
		Result:= DBXERR_INVALIDTXNID;
		Exit
	End;

	Assert(Trace('rollback %d', [FCurrentTransaction]));
	// commit to the dummy request handle
	cwbDB_SetHoldIndicator(commitHandle, CommitRetain[FCommitRetain], errHandle, ErrorHandler);
	cwbDB_Rollback(commitHandle, errHandle, ErrorHandler);

	FCurrentTransaction:= 0;

	// set isolation level back if different
	{ // can not yet support this for D7 because D6 misbehaves
	If FTransIsoLevel<>Trans.IsolationLevel Then Begin
		cwbDB_SetCommitmentControl(connectionHandle, CommitmentLevel[FTransIsoLevel], errHandle, ErrorHandler);
		cwbDB_ApplyAttributes(connectionHandle, errHandle, ErrorHandler)
	End;
	}
	Result:= DBXERR_NONE
end;

Procedure TCA400SQLConnection.ParseOptions(Value: WideString);
Var
	p: Integer;
	Option, Vals, UVals: WideString;
Begin
	While Value<>'' Do Begin
		p:= Pos(';', Value);
		If p=0 Then
			p:= Pos('/', Value);
		If p=0 Then Begin
			Option:= Value;
			Value:= ''
		End Else Begin
			Option:= Copy(Value, 1, p-1);
			Delete(Value, 1, p)
		End;
		p:= Pos('=', Option);
		If p=0 Then
			Vals:= ''
		Else Begin
			Vals:= Copy(Option, p+1, Length(Option));
			SetLength(Option, p-1)
		End;
		Option:= UpperCase(Option);
		UVals:= UpperCase(Vals);
				 If Option='SYSNAMING' Then    FSystemNaming:= Not(UVals='FALSE')
		Else If Option='FULLQUOTING' Then  FFullQuoting:= True
		Else If Option='MAPFLOAT' Then     FMapFloat:= True
		Else If Option='INT64ASBCD' Then   FInt64AsBCD:= True
		Else If Option='REUSESTMT' Then    FReuseStatementName:= True
		Else If Option='TRIMCHAR' Then     FTrimChar:= Not(UVals='FALSE')
		Else If Option='LIBS' Then         Libs.CommaText:= Vals
		Else If Option='SERVERCHARSET' Then SetServerCharSet(Vals)
		Else If Option='LOBTHRESHOLD' Then FLOBThreshold:= StrToIntDef(Vals, -1)
		Else If Option='TRACE' Then        FTraceLevel:= StrToIntDef(Vals, 0)
		Else If Option='LIMITMD' Then      FLIMITMD:= StrToIntDef(Vals, 0)
		Else If Option='DESCRIBE' Then     FDescribeOption:= StrToIntDef(Vals, 0)
		Else If Option='SORTTYPE' Then     FSortType:= StrToIntDef(Vals, 0)
		Else If Option='SORTTABLE' Then    WSortTable:= Vals
		Else If Option='SORTLIB' Then      WSortLib:= Vals
		Else If Option='ROLENAME' Then     WRole:= Vals
	End
End;

Procedure TCA400SQLConnection.SetConfigOptions (Value: WideString);
// parses ROLENAME=ROLE;option1=value;option2=value
// or ROLENAME=ROLE/option1=value/option2=value
Var
	p: Integer;
Begin
	Value:= Trim(Value);
	p:= Pos(';', Value);
	If p=0 Then
		p:= Pos('/', Value);
	If p>0 Then Begin
		ParseOptions(Copy(Value, p+1, Length(Value)));
		Value:= Trim(Copy(Value, 1, p-1))
	End;
	WRole:= Value
End;

Procedure TCA400SQLConnection.SetServerCharSet (Value: WideString);
Var
	p: Integer;
Begin
	Value:= Trim(Value);
	If Value='' Then
		Exit;
	p:= Pos(',', Value);
	If p=0 Then
		FHostCP:= StrToInt(Value)
	Else Begin
		FHostCP:= StrToInt(Trim(Copy(Value, 1, p-1)));
		FClientCP:= StrToInt(Trim(Copy(Value, p+1, Length(Value))))
	End
End;

function TCA400SQLConnection.GetErrHandle: cwbSV_ErrHandle;
begin
	If Assigned(FErrorHandler) Then
		Result:= ErrorHandler.ErrHandle
	Else
		Result:= 0
end;

Function TCA400SQLConnection.Trace(const Value: WideString; Reason: TSQLTraceFlag = traceMISC): Boolean;
var
	FTraceDesc: SQLTRACEDesc25;
	WTraceDesc: SQLTRACEDesc30;
	aStr: AnsiString;
begin
	Result:= True;
	If FTraceLevel And $1<>0 Then
		OutputDebugStringW(PWideChar(Value));
	If (FTraceLevel And $2=0)
	Or (FCallBack=Nil) Then
		Exit;

	try
		if FExpectWide then
		begin
			WTraceDesc.uTotalMsgLen:= Min(Length(Value), SizeOf(WTraceDesc.pszTrace) Div SizeOf(WChar));
			WStrLCopy(WTraceDesc.pszTrace, PWideChar(Value), FTraceDesc.uTotalMsgLen);
			WTraceDesc.eTraceCat:= 0;
			WTraceDesc.ClientData:= FCBInfo;
			TSQLCallbackEvent(FCallBack)(Integer(Reason), @WTraceDesc);
		end
		else
		begin
			aStr:= Value;
			FTraceDesc.uTotalMsgLen:= Min(Length(aStr), SizeOf(FTraceDesc.pszTrace));
			StrLCopy(FTraceDesc.pszTrace, PAnsiChar(aStr), FTraceDesc.uTotalMsgLen);
			FTraceDesc.eTraceCat:= 0;
			FTraceDesc.ClientData:= FCBInfo;
			TSQLCallbackEvent(FCallBack)(Integer(Reason), @FTraceDesc);
		end;
	except
		Result:= false
	end;
end;

function TCA400SQLConnection.Trace(const Value: WideString; Items: array of Const; Reason: TSQLTraceFlag = traceMISC): Boolean;
begin
	Result:= Trace(WideFormat(Value, Items), Reason)
end;

function TCA400SQLConnection.GetQualifier: WideChar;
begin
	If FSystemNaming Then
		Result:= '/'
	Else
		Result:= '.'
end;

Function TCA400SQLConnection.RetrieveLIBL (Value: WideString): WideString;
Var
	catHandle: cwbDB_RequestHandle;
	catdataHandle, catindicatorHandle: cwbDB_DataHandle;
	catformatHandle: cwbDB_FormatHandle;
	rowSize, rowsDataLength: Cardinal;
	rowCount, i: Integer;
	Count: Cardinal;
	templib: Array[0..100] Of Char;
	bufptr: PChar;
Begin
	Result:= '';
	Try
		cwbDB_CreateCatalogRequestHandle(connectionHandle, catHandle, errHandle, ErrorHandler);
		cwbDB_SetLibraryNameW(catHandle, PWideChar(Value), errHandle, ErrorHandler);
		cwbDB_CreateDataFormatHandle(connectionHandle, catformatHandle, errHandle, ErrorHandler);
		cwbDB_SetConversionIndicator(catformatHandle, CWB_FALSE, errHandle, ErrorHandler);
		cwbDB_CreateDataHandle(catdataHandle, errHandle, ErrorHandler);
		cwbDB_CreateDataHandle(catindicatorHandle, errHandle, ErrorHandler);
		cwbDB_ReturnDataFormat(catHandle, catformatHandle, errHandle, ErrorHandler);
		cwbDB_ReturnData(catHandle, catdataHandle, catindicatorHandle, catformatHandle, errHandle, ErrorHandler);
		cwbDB_RetrieveLibraryInformation(catHandle, CWBDB_GET_LIBRARY_NAME, errHandle, ErrorHandler);
		// each row contains only one entry, so we make our life a bit easier here
		cwbDB_GetRowSize(catformatHandle, CWBDB_LOCAL, rowSize, errHandle, ErrorHandler);
		If rowSize<>0 Then Begin
			cwbDB_GetDataLength(catdataHandle, rowsDataLength, errHandle, ErrorHandler);
			cwbDB_GetDataPointer(catdataHandle, Pointer(bufptr), errHandle, ErrorHandler);
			rowCount:= rowsDataLength Div rowSize;
			For i:= 1 To rowCount Do Begin
				ConvertCP(rowSize, bufptr, sizeof(templib), @templib, 37, FClientCP {1252}, Count, errHandle, ErrorHandler);
				templib[Count]:= #0;
				Inc(bufptr, rowSize);
				If Count>0 Then Begin
					If i>1 Then
						Result:= Result+',';
					Result:= Result+Trim(templib)
				End
			End
		End;
		// clean up missing here !!!
	Except
	End
End;

procedure TCA400SQLConnection.ExpandLibs;
Var
	s: String;
	p: Integer;
begin
	If FSystemNaming And (Libs.Count=0) Then
		Libs.Add(szLIBL);
	s:= Libs.CommaText;
	p:= Pos(szLIBL, UpperCase(s));
	If p>0 Then
		s:= Copy(s, 1, p-1)+RetrieveLIBL(szLIBL)+Copy(s,p+Length(szLIBL), Length(s));
	p:= Pos(szUSRLIBL, UpperCase(s));
	If p>0 Then
		s:= Copy(s, 1, p-1)+RetrieveLIBL(szUSRLIBL)+Copy(s,p+Length(szUSRLIBL), Length(s));
	Libs.CommaText:= s
end;

{ TCA400SQLCommand }

Constructor TCA400SQLCommand.Create(AOwner: TCA400SqlConnection);
Begin
	Inherited Create;
	FConnection:= AOwner;
	FConnection.FSQLCommands.Add(Self); // for transaction support
	FBlockCount:= -1; 						// -1 = leave BlockCount alone!
	FRequestType:= rtSQL;
End;

destructor TCA400SQLCommand.Destroy;
begin
	Assert(Trace('SQLCommand.destroy %d', [requestHandle]));
	If FCursorOpen Then
		close;
	ReleaseResources;
	FConnection.FSQLCommands.Remove(Self);
	inherited;
end;

function TCA400SQLCommand.close: SQLResult;
begin
	Assert(Trace('SQLCommand.close %d', [requestHandle]));
	If FCursorOpen Then Begin
		If FRequestType=rtSQL Then Begin
			// for stored procedures indicate to close only current cursor so the next resultset may be retrieved
			If FIsStoredProc Then
				cwbDB_SetCursorReuse(requestHandle, CWBDB_CLOSE_CURRENT_CURSOR, errHandle);
			Assert(Trace('Close Cursor %s', [FCurrentCursorName]));
			cwbDB_SetCursorName(requestHandle, PChar(FCurrentCursorName), errHandle, ErrorHandler);
			cwbDB_Close(requestHandle, errHandle, ErrorHandler)
		End;
		FCursorOpen:= False;

		// V4R5 and earlier do not reuse format Handles, so we get rid of em here
		If cwbRelease<cwbV5R1 Then Begin
			If formatHandle<>0 Then Begin
				cwbDB_DeleteDataFormatHandle(formatHandle, errHandle);
				formatHandle:= 0
			End;
			If pmformatHandle<>0 Then Begin
				cwbDB_DeleteParameterMarkerFormatHandle(pmformatHandle, errHandle);
				pmformatHandle:= 0;
			End
		End
	End;
	If FDirectQuery Then // for a query that will not be reexecuted, we release everything
		ReleaseResources;
	rowCount:= 0;
	curRow:= 0;
	Result:= DBXERR_NONE
end;

Procedure TCA400SQLCommand.ReleaseResources;
Begin
	Assert(Trace('ReleaseResources %d', [requestHandle]));
	FQuery:= '';
	dataBuffer:= Nil;
	indicatorBuffer:= Nil;
	outputDataBuffer:= Nil;
	outputIndicatorBuffer:= Nil;
	rowsDataBuffer:= Nil;
	rowsIndicatorBuffer:= Nil;

	curRow:= 0;
	rowCount:= 0;
	rowSize:= 0;
	rowSizeIndicator:= 0;
	bufferfilled:= False;

	FDirectQuery:= False;

	If Assigned(pmdataBuffer) Then Begin
		FreeMem(pmdataBuffer);
		pmdataBuffer:= Nil
	End;
	If Assigned(pmindicatorBuffer) Then Begin
		FreeMem(pmindicatorBuffer);
		pmindicatorBuffer:= Nil
	End;

	releaseLobHandles; // stored in Cols
	Cols:= Nil;
	Params:= Nil;
	uParams:= 0;
	uColumns:= 0;

	If pmformatHandle<>0 Then Begin
		cwbDB_DeleteParameterMarkerFormatHandle(pmformatHandle, errHandle);
		pmformatHandle:= 0;
	End;
	If formatHandle<>0 Then Begin
		cwbDB_DeleteDataFormatHandle(formatHandle, errHandle);
		formatHandle:= 0
	End;
	If indicatorHandle<>0 Then Begin
		cwbDB_DeleteDataHandle(indicatorHandle, errHandle);
		indicatorHandle:= 0;
	End;
	If dataHandle<>0 Then Begin
		cwbDB_DeleteDataHandle(dataHandle, errHandle);
		dataHandle:= 0
	End;
	If outputIndicatorHandle<>0 Then Begin
		cwbDB_DeleteDataHandle(outputIndicatorHandle, errHandle);
		outputIndicatorHandle:= 0;
	End;
	If outputDataHandle<>0 Then Begin
		cwbDB_DeleteDataHandle(outputDataHandle, errHandle);
		outputDataHandle:= 0
	End;
	If requestHandle<>0 Then Begin
		Assert(Trace('Delete request handle %d', [requestHandle]));
		Case FRequestType Of
			rtSQL:		 cwbDB_DeleteSQLRequestHandle(requestHandle, errHandle);
			rtCatalog: cwbDB_DeleteCatalogRequestHandle(requestHandle, errHandle);
			rtNative:  cwbDB_DeleteNDBRequestHandle(requestHandle, errHandle);
		End;
		requestHandle:= 0
	End;
	FreeAndNil(FErrorHandler)
End;

Procedure TCA400SQLCommand.ReleaseLobHandles;
Var
	i: Integer;
Begin
	If Cols=Nil Then
		Exit;
	For i:= 0 To Length(Cols)-1 Do With Cols[i] Do Begin
		If lobHandle<>0 Then Begin
			Assert(Trace('release lob handle %d', [lobHandle]));
			cwbDB_DeleteDataHandle(lobHandle, errHandle);
			lobHandle:= 0
		End;
		lobData:= Nil;
		lobLength:= 0
	End;
End;

function TCA400SQLCommand.prepare(SQL: WideString; ParamCount: Word): SQLResult;
Const
	szCALL = 'CALL ';
Var
	i: Integer;
	SchemaSpec, ObjectSpec: WideString;
begin
	Assert(Trace('SQLCommand.prepare conn=%d',[Conn.connectionHandle]));
	If Length(SQL)>=CA400_MAXSQLTEXT Then Begin
		Assert(Trace('SQL query too long'));
		Result:= DBXERR_OUTOFRANGE;
		Exit
	End;
	ReleaseResources;
	If FIsStoredProc And (Pos(szCALL, SQL)=0) Then Begin
		RetrieveSchemaObject(SQL, SchemaSpec, ObjectSpec);
		If SchemaSpec='' Then
			FQuery:= szCALL+ WideFormat('"%s"', [ObjectSpec])
		Else
			FQuery:= szCALL+ WideFormat('"%s"%s"%s"', [SchemaSpec, Conn.Qualifier, ObjectSpec]);
		If ParamCount>0 Then Begin
			FQuery:= FQuery+'(?';
			For i:= 2 To ParamCount Do
				FQuery:= FQuery+',?';
			FQuery:= FQuery+')'
		End
	End Else
		FQuery:= CleanSQL(SQL); // Trim and remove #13#10

	FRequestType:= rtSQL;
	If UpperCase(Copy(FQuery, 1, 8))=stCATALOG Then
		FRequestType:= rtCatalog
	Else If UpperCase(Copy(FQuery, 1, 7))=stNATIVE Then
		FRequestType:= rtNative;

	Case FRequestType Of
		rtSQL:		 cwbDB_CreateSQLRequestHandle(Conn.connectionHandle, requestHandle, errHandle, Conn.ErrorHandler);
		rtCatalog: cwbDB_CreateCatalogRequestHandle(Conn.connectionHandle, requestHandle, errHandle, Conn.ErrorHandler);
		rtNative:  cwbDB_CreateNDBRequestHandle(Conn.connectionHandle, requestHandle, errHandle, Conn.ErrorHandler);
	End;
	FErrorHandler:= TcwbDBErrorHandler.Create(requestHandle);

	cwbDB_CreateDataFormatHandle(Conn.connectionHandle, formatHandle, errHandle, ErrorHandler);
	cwbDB_SetConversionIndicator(formatHandle, CWB_FALSE, errHandle, ErrorHandler);
	cwbDB_CreateParameterMarkerFormatHandle (Conn.connectionHandle, pmformatHandle, errHandle, ErrorHandler);
	cwbDB_SetConversionIndicator(pmformatHandle, CWB_FALSE, errHandle, ErrorHandler);
	cwbDB_CreateDataHandle(dataHandle, errHandle, ErrorHandler);
	cwbDB_CreateDataHandle(indicatorHandle, errHandle, ErrorHandler);

	Case FRequestType Of
		rtSQL: Result:= PrepareSQL(ParamCount);
		rtCatalog: Result:= PrepareCatalog;
		rtNative: Result:= PrepareNative;
	Else
		Result:= DBXERR_NOTSUPPORTED
	End;
end;

Function TCA400SQLCommand.PrepareSQL (ParamCount: Word): SQLResult;
Var
	StatementName: String;
	PackageName, LibraryName, s: String;
	p: Integer;
Begin
	// check for embedded package name
	PackageName:= '';
	LibraryName:= '';
	p:= Pos('/*', FQuery);
	If (p>0) Then Begin
		s:= UpperCase(Trim(Copy(FQuery, p+2, 40)));
		p:= Pos('=', s);
		If (p>0) And (Trim(Copy(s, 1, p-1))='PKG') Then Begin
			s:= Trim(Copy(s, p+1, Pos('*/', s)-p-1));
			p:= Pos('.', s);
			If p=0 Then
				PackageName:= s
			Else Begin
				PackageName:= Trim(Copy(s,p+1,Length(s)));
				LibraryName:= Trim(Copy(s,1,p-1))
			End
		End
	End;

	// we implement this as an option until we know how to prevent/enable statement reuse
	Conn.FId:= Conn.FId+1; // make unique id to prevent statement name errors
	if Conn.FReuseStatementName then
		StatementName:= Format('DBXSTM%d', [Cardinal(requestHandle)])
	else
		StatementName:= Format('DBXSTM%d-%d', [Cardinal(requestHandle), Conn.FId]);
	Assert(Trace('setStatementName to %s', [StatementName]));
	cwbDB_SetStatementName(requestHandle, PChar(StatementName), errHandle, ErrorHandler);

	Assert(Trace('setStatementText to %s', [FQuery]));
	cwbDB_SetStatementText(requestHandle, PChar(FQuery), errHandle, ErrorHandler);

	FCurrentCursorName:= Format('DBXCRS%d-%d', [Cardinal(requestHandle), Conn.FId]);

	// set block count for request
	If FBlockCount>0 Then Begin
		Assert(Trace('setBlockCount to %d', [FBlockCount]));
		cwbDB_SetBlockCount(requestHandle, FBlockCount, errHandle);
	End;

	cwbDB_SetQueryTimeoutValue(requestHandle, Conn.FTimeOut, errHandle);

	Case Conn.FDescribeOption Of
		1: cwbDB_SetDescribeOption(requestHandle, CWBDB_DESC_NAMES_ONLY, errHandle, ErrorHandler);
		2: cwbDB_SetDescribeOption(requestHandle, CWBDB_DESC_LABELS, errHandle, ErrorHandler);
	Else
		cwbDB_SetDescribeOption(requestHandle, CWBDB_DESC_ALIAS_NAMES, errHandle, ErrorHandler);
	End;

	If PackageName<>'' Then Begin
		cwbDB_SetPackageName(requestHandle, PChar(PackageName), errHandle, ErrorHandler);
		If LibraryName<>'' Then
			cwbDB_SetLibraryName(requestHandle, PChar(LibraryName), errHandle, ErrorHandler);

		cwbDB_SetPrepareOption(requestHandle, CWBDB_ENHANCED_PREPARE, errHandle, ErrorHandler)
	End;

	cwbDB_StoreRequestParameters(requestHandle, errHandle, ErrorHandler);

	// prepare package if not existant
	If PackageName<>'' Then
		cwbDB_CreatePackage(requestHandle, errHandle, ErrorHandler);

	cwbDB_ReturnParameterMarkerFormat(requestHandle, pmformatHandle, errHandle, ErrorHandler);
	cwbDB_ReturnDataFormat(requestHandle, formatHandle, errHandle, ErrorHandler);
	cwbDB_PrepareDescribe(requestHandle, errHandle, ErrorHandler);
	cwbDB_GetParameterCount(pmformatHandle, uParams, errHandle, ErrorHandler);
	cwbDB_GetColumnCount(formatHandle, uColumns, errHandle, ErrorHandler);
	Assert(Trace('%d Columns, %d Params returned', [uColumns, uParams]));

	DescribeColumns;
	DescribeParameters;

	If uParams<>ParamCount Then
		Assert(Trace('passed %d parameters but parsed %d parameters', [ParamCount, uParams]));

	Result:= DBXERR_NONE
End;

Function TCA400SQLCommand.PrepareCatalog: SQLResult;
// format: CATALOG Retrieve(Library) Library(*all)
Var
	Value, Cmd: String;

	Function ParseOut (Topic: String; Var Value: String): Boolean;
	Var
		p: Integer;
	Begin
		Value:= '';
		Topic:= Trim(UpperCase(Topic))+'(';
		p:= Pos(Topic, UpperCase(FQuery));
		If p>0 Then Begin
			Value:= Copy(FQuery, p+Length(Topic), Length(FQuery));
			p:= Pos(')', Value);
			If p=0 Then Begin
				Value:= '';
				Result:= False
			End Else Begin
				Value:= Trim(Copy(Value, 1, p-1));
				Result:= True
			End
		End Else
			Result:= False
	End;

	Function FT (Const Value: String): Word;
	Begin
		Result:= CWBDB_ALL_FILES;
		If (Length(Value)>=2) And (Value[1]='*') Then
			Case Value[2] Of
				'S': Result:= CWBDB_SOURCE_FILES;
				'D': Result:= CWBDB_DATA_FILES;
			End
	End;

	Function FA (Const Value: String): Word;
	Begin
		Result:= CWBDB_ALL_FILES_ATTRIBUTES;
		If (Length(Value)>=2) And (Value[1]='*') Then
			Case Value[2] Of
				'P': Result:= CWBDB_PHYSICAL_FILES_ATTRIBUTES;
				'L': Result:= CWBDB_LOGICAL_FILES_ATTRIBUTES;
				'T': Result:= CWBDB_ODBC_TABLES_ATTRIBUTES;
				'V': Result:= CWBDB_ODBC_VIEWS_ATTRIBUTES;
			End
	End;

Begin
	Assert(Trace('prepareCatalog'));

	If Not ParseOut('Retrieve', Cmd) Then Begin
		Result:= DBXERR_NOTSUPPORTED;
		Exit
	End;

	If ParseOut('Library', Value) Then cwbDB_SetLibraryName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('Package', Value) Then cwbDB_SetPackageName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('Member', Value)  Then cwbDB_SetMemberName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('Field', Value)   Then cwbDB_SetFieldName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('File', Value)    Then cwbDB_SetFileName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('PrimaryKeyFile', Value) Then cwbDB_SetPrimaryKeyFileName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('PrimaryKeyLib', Value) Then cwbDB_SetPrimaryKeyLibName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('ForeignKeyFile', Value) Then cwbDB_SetForeignKeyFileName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('ForeignKeyLib', Value) Then cwbDB_SetForeignKeyLibName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('Format', Value) Then cwbDB_SetFormatName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('LongFile', Value) Then cwbDB_SetLongFileName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('RDB', Value) Then cwbDB_SetRDBName(requestHandle, PChar(Value), errHandle, ErrorHandler);
	If ParseOut('FileType', Value) Then cwbDB_SetFileType(requestHandle, FT(Value), errHandle, ErrorHandler);
	If ParseOut('FileAttr', Value) Then cwbDB_SetFileAttributes(requestHandle, FA(Value), errHandle, ErrorHandler);

	cwbDB_ReturnDataFormat(requestHandle, formatHandle, errHandle, ErrorHandler);
	cwbDB_ReturnData(requestHandle, dataHandle, indicatorHandle, formatHandle, errHandle, ErrorHandler);

	Cmd:= UpperCase(Cmd);
	If Cmd='SQLPACKAGE'       Then cwbDB_RetrieveSQLPackageInformation(requestHandle, CWBDB_GET_SQLPKG_ALL, errHandle, ErrorHandler) Else
	If Cmd='LIBRARY'          Then cwbDB_RetrieveLibraryInformation(requestHandle, CWBDB_GET_LIBRARY_ALL, errHandle, ErrorHandler) Else
	If Cmd='PACKAGESTATEMENT' Then cwbDB_RetrievePackageStatementInformation(requestHandle, CWBDB_GET_SQLSTMT_ALL, errHandle, ErrorHandler) Else
	If Cmd='PRIMARYKEY'       Then cwbDB_RetrievePrimaryKeyInformation(requestHandle, CWBDB_GET_PR_KEY_ALL, errHandle, ErrorHandler) Else
	If Cmd='RDB'              Then cwbDB_RetrieveRDBInformation(requestHandle, CWBDB_GET_RDB_ALL, errHandle, ErrorHandler) Else
	If Cmd='RECORDFORMAT'     Then cwbDB_RetrieveRecordFormatInformation(requestHandle, CWBDB_GET_FMT_ALL, errHandle, ErrorHandler) Else
	If Cmd='SPECIALCOLUMN'    Then cwbDB_RetrieveSpecialColumnInformation(requestHandle, CWBDB_GET_SP_COL_ALL, errHandle, ErrorHandler) Else
	If Cmd='MEMBER'           Then cwbDB_RetrieveMemberInformation(requestHandle, CWBDB_GET_MBR_ALL, errHandle, ErrorHandler) Else
	If Cmd='INDEX'            Then cwbDB_RetrieveIndexInformation(requestHandle, CWBDB_GET_IDX_ALL, errHandle, ErrorHandler) Else
	If Cmd='FOREIGNKEY'       Then cwbDB_RetrieveForeignKeyInformation(requestHandle, CWBDB_GET_FG_KEY_ALL, errHandle, ErrorHandler) Else
	If Cmd='FILE'             Then cwbDB_RetrieveFileInformation(requestHandle, CWBDB_GET_FILE_ALL, errHandle, ErrorHandler) Else
	If Cmd='FIELD'            Then cwbDB_RetrieveFieldInformation(requestHandle, CWBDB_GET_FLD_ALL, errHandle, ErrorHandler);

	cwbDB_GetColumnCount(formatHandle, uColumns, errHandle, ErrorHandler);
	Assert(Trace('Catalog returned %d Columns', [uColumns]));
	DescribeColumns;

	Result:= DBXERR_NONE;
End;

Function TCA400SQLCommand.PrepareNative: SQLResult;
Begin
	Result:= DBXERR_NONE;
End;

Function TCA400SQLCommand.Execute(Var Cursor: TCA400SQLCursor): SQLResult;
Var
	SQLCA: cwbDB_SQLCA;
Begin
	Assert(Trace('execute %d', [Cardinal(requestHandle)]));
	Cursor:= Nil;
	rowsaffected:= -1;
	resultsets:= 0;
	If (uColumns=0) or FIsStoredProc Then Begin
		If uParams>0 Then
			cwbDB_SetParameterMarkers(requestHandle, pmformatHandle, pmdataBuffer, pmindicatorBuffer, errHandle, ErrorHandler);
		cwbDB_ReturnSQLCA(requestHandle, SQLCA, errHandle, ErrorHandler);
		// ask for parameter data to be returned if stored procedure and there are output parameters
		If FIsStoredProc And (outputDataHandle<>0) Then
			cwbDB_ReturnData(requestHandle, outputDataHandle, outputIndicatorHandle, pmformatHandle, errHandle, ErrorHandler);

		cwbDB_Execute(requestHandle, errHandle, ErrorHandler);

		If FIsStoredProc And (outputDataHandle<>0) Then Begin
			cwbDB_GetDataPointer(outputDataHandle, Pointer(outputDataBuffer), errHandle, ErrorHandler);
			cwbDB_GetDataPointer(outputIndicatorHandle, outputIndicatorBuffer, errHandle, ErrorHandler);
		End;

		// determine affected rows and number of result sets for SP
		resultsets:=	 SQLCA.sqlerrd[1];
		rowsaffected:= SQLCA.sqlerrd[2];
		Assert(Trace('%d rows affected, %d result sets', [rowsaffected, resultsets]));

		// return result set/cursor if SP has one
		If resultsets>0 Then Begin
			Result:= GetNextCursor(Cursor);
			Exit
		End
	End Else Begin
		Cursor:= TCA400SQLCursor.Create(Self);
		Open
	End;
	Result:= DBXERR_NONE
End;

Procedure TCA400SQLCommand.Open;
Begin
	Assert(Trace('SQLCommand.open conn=%d', [Conn.connectionHandle]));
	If FCursorOpen Then Begin
		Assert(Trace('warning: previous cursor was not closed'));
		FCursorOpen:= False
	End;
	// we do not reuse format handles for releases <V5R1, because it is not supported
	// even if we do not reuse format handle, we do not call DescribeColumns again,
	// because we assume that the Column format does not change between closecursor/opencursor
	If formatHandle=0 Then Begin
		cwbDB_CreateDataFormatHandle(Conn.connectionHandle, formatHandle, errHandle, ErrorHandler);
		cwbDB_SetConversionIndicator(formatHandle, CWB_FALSE, errHandle, ErrorHandler);
		cwbDB_ReturnDataFormat(requestHandle, formatHandle, errHandle, ErrorHandler);
		cwbDB_Describe(requestHandle, errHandle, ErrorHandler);
	End;

	If uParams>0 Then Begin
		If pmFormatHandle=0 Then Begin
			cwbDB_CreateParameterMarkerFormatHandle (Conn.connectionHandle, pmformatHandle, errHandle, ErrorHandler);
			cwbDB_SetConversionIndicator(pmformatHandle, CWB_FALSE, errHandle, ErrorHandler);
			cwbDB_ReturnParameterMarkerFormat(requestHandle, pmformatHandle, errHandle, ErrorHandler);
			cwbDB_DescribeParameterMarkers(requestHandle, errHandle, ErrorHandler);
		End;
		cwbDB_SetParameterMarkers(requestHandle, pmformatHandle, pmdataBuffer, pmindicatorBuffer, errHandle, ErrorHandler)
	End;

	If FRequestType=rtSQL Then Begin
		Assert(Trace('Open Cursor %s', [FCurrentCursorName]));
		cwbDB_SetCursorName(requestHandle, PChar(FCurrentCursorName), errHandle, ErrorHandler);
		cwbDB_Open(requestHandle, CWBDB_READ, errHandle, ErrorHandler);
	End;
	FCursorOpen:= True
End;

function TCA400SQLCommand.GetNextCursor(var Cursor: TCA400SQLCursor): SQLResult;
Begin
	Assert(Trace('SQLCommand.getNextCursor'));
	Cursor:= Nil;
	If resultsets>0 Then Begin
		Dec(resultsets);

		If FCursorOpen Then Begin
			If FRequestType=rtSQL Then Begin
				Assert(Trace('Close Cursor %s', [FCurrentCursorName]));
				cwbDB_SetCursorName(requestHandle, PChar(FCurrentCursorName), errHandle, ErrorHandler);
				cwbDB_Close(requestHandle, errHandle, ErrorHandler);
			End;
			FCursorOpen:= False;
		End;

		// we need a new format handle for the result set as the previous is either from
		// the stored procedure prepare or from the previous result set
		If formatHandle<>0 Then
			cwbDB_DeleteDataFormatHandle(formatHandle, errHandle);
		cwbDB_CreateDataFormatHandle(Conn.connectionHandle, formatHandle, errHandle, ErrorHandler);
		cwbDB_SetConversionIndicator(formatHandle, CWB_FALSE, errHandle, ErrorHandler);
		cwbDB_ReturnDataFormat(requestHandle, formatHandle, errHandle, ErrorHandler);
		Cursor:= TCA400SQLCursor.Create(Self);
		Assert(Trace('GetNextCursor %s', [FCurrentCursorName]));
		cwbDB_SetCursorName(requestHandle, PChar(FCurrentCursorName), errHandle, ErrorHandler);
		cwbDB_Open(requestHandle, CWBDB_READ, errHandle, ErrorHandler);
		FCursorOpen:= True;
		cwbDB_GetColumnCount(formatHandle, uColumns, Conn.errHandle, ErrorHandler);
		Assert(Trace('%d Columns returned', [uColumns]));
		DescribeColumns;
		Result:= DBXERR_NONE
	End Else
		Result:= SQL_NULL_DATA
End;

function TCA400SQLCommand.executeImmediate(SQL: PWideChar; var Cursor: TCA400SQLCursor): SQLResult;
begin
	FDirectQuery:= True;
	Result:= prepare(SQL, 0);
	If Result=DBXERR_NONE Then
		Result:= execute(Cursor)
end;

function TCA400SQLCommand.SetOption(eSqlCommandOption: TSQLCommandOption; ulValue: Integer): SQLResult;
begin
	Result:= DBXERR_NONE;
	Case eSqlCommandOption Of
		eCommBlobSize:	FBlobSize:= ulValue;
		eCommRowsetSize: FBlockCount:= ulValue;
		eCommStoredProc: FIsStoredProc:= ulValue=1;
		{$IfNDef VER140}
		eCommPackageName: ;
		{$EndIf}
	Else
		Result:= DBXERR_NOTSUPPORTED
	End
end;

function TCA400SQLCommand.getErrorMessage: WideString;
begin
	Result:= Conn.getErrorMessage
end;

function TCA400SQLCommand.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin
	Result:= Conn.getErrorMessageLen(ErrorLen)
end;

function TCA400SQLCommand.GetOption(eSqlCommandOption: TSQLCommandOption;  {$IfDef VER140} var pValue: Integer {$Else} pValue: Pointer {$EndIf}; MaxLength: SmallInt; out Length: SmallInt): SQLResult;
begin
	Result:= DBXERR_NONE;
	Case eSqlCommandOption Of
		eCommRowsetSize: Result:= DBXERR_NOTSUPPORTED;
		eCommNativeHandle: Begin THandle(Pointer(pValue)^):= requestHandle; Length:= SizeOf(THandle) End;
	Else
		Result:= DBXERR_NOTSUPPORTED
	End
end;

function TCA400SQLCommand.getParameter(ParameterNumber, ulChildPos: Word; Value: Pointer; Length: Integer; var IsBlank: Integer): SQLResult;
begin
	If (ParameterNumber<1) Or (ParameterNumber>uParams) Then
		Result:= DBXERR_INVALIDPARAM
	Else
		Result:= bdpGetParameter(ParameterNumber, ulChildPos, Params[ParameterNumber-1].LogType, Value, Length, IsBlank)
end;

function TCA400SQLCommand.bdpGetParameter(ParameterNumber, ulChildPos: Word; VarType: Word; Value: Pointer; Length: Integer; var IsBlank: Integer): SQLResult;
Var
	Index: Integer;
	p: Pointer;
begin
	Index:= ParameterNumber-1;
	If (ParameterNumber<1) Or (ParameterNumber>uParams) Or (Params[Index].ParamType=paramIN) Then
		Result:= DBXERR_INVALIDPARAM
	Else
		If Length>=Integer(Params[Index].PhyLength) Then
			Result:= GetData(VarType, Params[Index], Value, LongBool(IsBlank))
		Else Begin
			p:= AllocMem(Params[Index].PhyLength);
			Try
				Result:= GetData(VarType, Params[Index], p, LongBool(IsBlank));
				Move(p^, Value^, Length)
			Finally
				FreeMem(p)
			End
		End
end;

function TCA400SQLCommand.getRowsAffected(var Rows: LongWord): SQLResult;
begin
	Rows:= rowsaffected;
	Result:= DBXERR_NONE
end;

Function TCA400SQLCommand.GetConn: TCA400SQLConnection;
Begin
	If FConnection=Nil Then
		Raise ECA400InvalidConnection.Create('Invalid connection')
	Else
		Result:= FConnection
End;

Function TCA400SQLCommand.GetErrHandle: cwbSV_ErrHandle;
Begin
	Result:= Conn.ErrHandle
End;

Procedure TCA400SQLCommand.describeColumns;
Var
	nameHandle: cwbDB_DataHandle;
	i: Cardinal;
	columnPosition: Cardinal;
	namelen: Cardinal;
	nameptr: PAnsiChar;
	S: AnsiString;
	curOffset: Cardinal;
	aWord: Word;
Begin
	Assert(Trace('describeColumns'));

	If uColumns=0 Then
		Exit;

	cwbDB_CreateDataHandle(nameHandle, errHandle, ErrorHandler);
	Try
		SetLength(Cols, uColumns);
		curOffset:= 0;
		For i:= 0 To uColumns-1 Do With Cols[i] Do Begin
			columnPosition:= i+1; // Column positions start at 1
			isParam:= False;
			Num:= i;
			Offset:= curOffset;

			// Get column name into the data handle nameHandle
			cwbDB_GetColumnName(formatHandle, columnPosition, nameHandle, errHandle, ErrorHandler);
			cwbDB_GetDataLength(nameHandle, namelen, errHandle, ErrorHandler);
			If namelen>0 Then Begin
				If namelen>CA400_MAXCOLUMNNAME Then
					namelen:= CA400_MAXCOLUMNNAME;
				cwbDB_GetDataPointer(nameHandle, Pointer(nameptr), errHandle, ErrorHandler);
				SetLength(S, namelen);
				StrLCopy(PAnsiChar(S), nameptr, namelen);
				Name:= Trim(S);
			End Else
				Name:= Format('COL%d', [i]);

			cwbDB_GetColumnType(formatHandle, CWBDB_LOCAL, columnPosition, PhyType, errHandle, ErrorHandler);
			cwbDB_GetColumnType(formatHandle, CWBDB_SYSTEM, columnPosition, PhyTypeAS400, errHandle, ErrorHandler);
			cwbDB_GetColumnLength(formatHandle, CWBDB_LOCAL, columnPosition, PhyLength, errHandle, ErrorHandler);
			cwbDB_GetColumnPrecision(formatHandle, CWBDB_LOCAL, columnPosition, Precision, errHandle, ErrorHandler);
			cwbDB_GetColumnScale(formatHandle, CWBDB_LOCAL, columnPosition, Scale, errHandle, ErrorHandler);
			cwbDB_GetColumnCCSID(formatHandle, CWBDB_SYSTEM, columnPosition, aWord, errHandle, ErrorHandler);
			cwbNL_CCSIDToCodePage(aWord, PhyCP, errHandle, ErrorHandler);

			// override if user requested it
			If Conn.FHostCP<>0 Then
				PhyCP:= Conn.FHostCP;

			Case PhyType Of
				CWBDB_PCBLOBLOCATOR,
				CWBDB_PCCLOBLOCATOR,
				CWBDB_PCDBCLOBLOCATOR:
				begin
					cwbDB_GetColumnLength(formatHandle, CWBDB_SYSTEM, columnPosition, PhyLength, errHandle, ErrorHandler);
					cwbDB_GetLOBMaxSize(formatHandle, columnPosition, PhyLOBLength, errHandle);
				end;
				CWBDB_PCBLOB,
				CWBDB_PCCLOB,
				CWBDB_PCDBCLOB: PhyLOBLength:= PhyLength-4;
			end;
			setLogicalTypeInfo(Cols[i]);
			Inc(curOffset, PhyLength)
		end
	Finally
		cwbDB_DeleteDataHandle(nameHandle, errHandle, ErrorHandler)
	End
End;

Procedure TCA400SQLCommand.describeParameters;
Var
	paramLength: Cardinal;
	IsInput, IsInputOutput: cwb_Boolean;
	nameHandle: cwbDB_DataHandle;
	i: Cardinal;
	paramPosition: Cardinal;
	namelen: Cardinal;
	nameptr: PChar;
	S: String;
	curOffset: Cardinal;
	hasOutputParams: Boolean;
	aWord: Word;
Begin
	Assert(Trace('describeParameters'));
	If pmdataBuffer<>Nil Then Begin
		FreeMem(pmdataBuffer);
		pmdataBuffer:= Nil
	End;
	If pmindicatorBuffer<>Nil Then Begin
		FreeMem(pmindicatorBuffer);
		pmindicatorBuffer:= Nil
	End;

	If uParams=0 Then
		Exit;

	hasOutputParams:= False;
	cwbDB_CreateDataHandle(nameHandle, errHandle, ErrorHandler);
	Try
		SetLength(Params, uParams);
		curOffset:= 0;
		For i:= 0 To uParams-1 Do With Params[i] Do Begin
			paramPosition:= i+1; // Column positions start at 1
			isParam:= True;
			Num:= i;
			Offset:= curOffset;

			// ParameterName only supported since V5R1
			if cwbDB_GetParameterName(pmformatHandle, paramPosition, nameHandle, errHandle)=cwb_OK then
			begin
				cwbDB_GetDataLength(nameHandle, namelen, errHandle, ErrorHandler);
				If namelen>0 Then Begin
					If namelen>CA400_MAXPARAMNAME Then
						namelen:= CA400_MAXPARAMNAME;
					cwbDB_GetDataPointer(nameHandle, Pointer(nameptr), errHandle, ErrorHandler);
					SetLength(S, namelen);
					StrLCopy(PAnsiChar(S), nameptr, namelen);
					Name:= Trim(S)
				End
			End Else
				namelen:= 0;
			If namelen=0 Then
				Name:= Format('PARAM%d', [i]);

			cwbDB_GetParameterType(pmformatHandle, CWBDB_LOCAL, paramPosition, PhyType, errHandle, ErrorHandler);
			cwbDB_GetParameterType(pmformatHandle, CWBDB_SYSTEM, paramPosition, PhyTypeAS400, errHandle, ErrorHandler);
			cwbDB_GetParameterLength(pmformatHandle, CWBDB_LOCAL, paramPosition, PhyLength, errHandle, ErrorHandler);
			cwbDB_GetParameterPrecision(pmformatHandle, CWBDB_LOCAL, paramPosition, Precision, errHandle, ErrorHandler);
			cwbDB_GetParameterScale(pmformatHandle, CWBDB_LOCAL, paramPosition, Scale, errHandle, ErrorHandler);
			// is there a bug in cwbDB_GetParameterCCSID because it returns 0 ???
			cwbDB_GetParameterCCSID(pmformatHandle, CWBDB_SYSTEM, paramPosition, aWord, errHandle, ErrorHandler);
			cwbNL_CCSIDToCodePage(aWord, PhyCP, errHandle, ErrorHandler);
			If PhyCP=0 Then
				PhyCP:= 37;

			// override if user requested it
			If Conn.FHostCP<>0 Then
				PhyCP:= Conn.FHostCP;

			// avoid calling GetParameterDirection as this is supported only since V5R1!
			cwbDB_IsParameterInput(pmformatHandle, paramPosition, IsInput, errHandle, ErrorHandler);
			cwbDB_IsParameterInputOutput(pmformatHandle, paramPosition, IsInputOutput, errHandle, ErrorHandler);
			If IsInputOutput<>0 Then
				PhyDir:= CWBDB_PM_INPUT_OUTPUT
			Else
				If IsInput<>0 Then
					PhyDir:= CWBDB_PM_INPUT_ONLY
				Else
					PhyDir:= CWBDB_PM_OUTPUT_ONLY;
			If PhyDir<>CWBDB_PM_INPUT_ONLY Then
				hasOutputParams:= True;
			setLogicalTypeInfo(Params[i]);
			Inc(curOffset, PhyLength)
		End
	Finally
		cwbDB_DeleteDataHandle(nameHandle, errHandle, ErrorHandler)
	End;

	if cwbDB_GetSizeOfParameters(pmformatHandle, paramLength, errHandle)<>cwb_OK then
		cwbDB_GetSizeOfInputParameters(pmformatHandle, CWBDB_LOCAL, paramLength, errHandle, ErrorHandler);
	Assert(Trace('Size of parameters: %d bytes', [paramLength]));
	GetMem(pmdataBuffer, paramLength);
	GetMem(pmindicatorBuffer, uParams*2);

	If hasOutputParams Then Begin
		cwbDB_CreateDataHandle(outputDataHandle, errHandle, ErrorHandler);
		cwbDB_CreateDataHandle(outputIndicatorHandle, errHandle, ErrorHandler)
	End
End;

Function TCA400SQLCommand.fetch: SQLResult;
begin
	Result:= DBXERR_NONE;
	releaseLobHandles; // in case we fetched lob data, release it first
	If curRow>=rowCount Then // also true for curRow==0, rowCount==0 (first fetch) !
		If (rowCount>0) And Not bufferFilled Then
			Result:= DBXERR_EOF
		Else
			Result:= fetchRows;
	If Result=DBXERR_NONE Then Begin
		dataBuffer:= rowsDataBuffer+(rowSize*curRow);
		indicatorBuffer:= Pointer(PChar(rowsIndicatorBuffer)+(rowSizeIndicator*curRow*2));
		Inc(curRow)
	End
end;

Function TCA400SQLCommand.fetchRows: SQLResult;
Var
	rowsDataLength: Cardinal;
	rowsIndicatorLength: Cardinal;
	rc: cwb_Result;
Begin
	Result:= DBXERR_EOF;
	rowsDataLength:= 0;
	rowsIndicatorLength:= 0;
	rowsDataBuffer:= Nil;
	rowsIndicatorBuffer:= Nil;
	rowCount:= 0;
	curRow:= 0;

	Assert(Trace('fetchRows'));
	// rqCatalog is special: data is already fetched through Retrieve... API and there will
	// be no further fetch, so an EOF should be signaled after traveling through the first buffer
	If FRequestType=rtCatalog Then
		bufferFilled:= False
	Else Begin
		Assert(Trace('Fetch from Cursor %s', [FCurrentCursorName]));
		cwbDB_SetCursorName(requestHandle, PChar(FCurrentCursorName), errHandle, ErrorHandler);
		cwbDB_ReturnData(requestHandle, dataHandle, indicatorHandle, formatHandle, errHandle, ErrorHandler);
		rc:= cwbDB_Fetch(requestHandle, errHandle, ErrorHandler);
		If (rc=CWBDB_SQL_PARAMETER_WARNING) And (ErrorHandler.hostErrorClass=2) And (ErrorHandler.hostErrorCode=701) Then
			bufferFilled:= False
		Else
			bufferFilled:= True;
		If (rc<>CWB_OK) And (ErrorHandler.hostErrorClass=1) And (ErrorHandler.hostErrorCode=100) Then
			Exit
	End;

	cwbDB_GetRowSize(formatHandle, CWBDB_LOCAL, rowSize, errHandle, ErrorHandler);
	If rowSize=0 Then
		Exit;
	cwbDB_GetDataLength(dataHandle, rowsDataLength, errHandle, ErrorHandler);
	If rowsDataLength=0 Then
		Exit;
	cwbDB_GetDataPointer(dataHandle, Pointer(rowsDataBuffer), errHandle, ErrorHandler);
	rowCount:= rowsDataLength Div rowSize;
	cwbDB_GetDataLength(indicatorHandle, rowsIndicatorLength, errHandle, ErrorHandler);
	If rowsIndicatorLength>0 Then
		cwbDB_GetDataPointer(indicatorHandle, rowsIndicatorBuffer, errHandle, ErrorHandler);
	rowSizeIndicator:= rowsIndicatorLength Div (rowCount*2);
	Assert(Trace('fetched %d rows, %d bytes', [rowCount, rowsDataLength]));
	Result:= DBXERR_NONE
End;

Function TCA400SQLCommand.fetchBlob(Var Item: TColumnParam; locator: Cardinal): SQLResult;
Begin
	Result:= DBXERR_NONE;
	With Item Do Begin
		If lobData<>Nil Then
			Exit; // blob already fetched, probably due to getBlobSize call
		If lobHandle=0 Then
			cwbDB_CreateDataHandle(lobHandle, errHandle, ErrorHandler);
		cwbDB_RetrieveLOBData(requestHandle, lobHandle, locator, PhyLOBLength, 0 {Start}, Item.Num+1 {Column}, errHandle, ErrorHandler);
		cwbDB_GetDataLength(lobHandle, lobLength, errHandle, ErrorHandler);
		If lobLength>0 Then
			cwbDB_GetDataPointer(lobHandle, lobData, errHandle, ErrorHandler)
	End
End;

Function TCA400SQLCommand.GetSize(getType: Word; Var Item: TColumnParam; Var Len: LongWord; var IsBlank: LongBool): SQLResult;
Var
	p, db, ib: Pointer;

	Function BufferOfs (Value: Cardinal): Pointer;
	Begin
		Result:= PChar(db)+Value
	End;

Begin
	Result:= DBXERR_NONE;
	If Item.IsParam Then Begin
		db:= outputDataBuffer;
		ib:= outputIndicatorBuffer
	End Else Begin
		db:= DataBuffer;
		ib:= indicatorBuffer
	End;

	With Item Do Begin
		If (db=Nil) Or ((ib<>Nil) And (TSmallIntArray(ib^)[num]=-1)) Then Begin
			IsBlank:= True;
			Exit
		End Else
			IsBlank:= False;

		p:= BufferOfs(Offset);
		Case PhyType Of
			CWBDB_PCBLOB: Len:= IntToInt(Cardinal(p^));
			CWBDB_PCCLOB: Len:= IntToInt(Cardinal(p^));
			CWBDB_PCDBCLOB: Len:= IntToInt(Cardinal(p^)) Div 2;
			CWBDB_PCBLOBLOCATOR,
			CWBDB_PCCLOBLOCATOR: Begin
				fetchBlob(Item, Cardinal(p^));
				Len:= lobLength
			End;
			CWBDB_PCDBCLOBLOCATOR: Begin
				fetchBlob(Item, Cardinal(p^));
				Len:= lobLength Div 2;
			End;
		Else
			Result:= DBXERR_INVALIDXLATION
		End
	End
End;

function TCA400SQLCommand.GetData(getType: Word; Var Item: TColumnParam; Value: Pointer; var IsBlank: LongBool): SQLResult;
Var
	p, db, ib: Pointer;
	Count: Cardinal;

	Function BufferOfs (Value: Cardinal): Pointer;
	Begin
		Result:= PChar(db)+Value
	End;

	Function GetStr (Len: Integer; Value: PChar): String;
	Begin
		SetLength(Result, Len);
		StrLCopy(PChar(Result), Value, Len)
	End;

Begin
	Result:= DBXERR_NONE;
	If Item.IsParam Then Begin
		db:= outputDataBuffer;
		ib:= outputIndicatorBuffer
	End Else Begin
		db:= DataBuffer;
		ib:= indicatorBuffer
	End;

	With Item Do Begin
		If (db=Nil) Or ((ib<>Nil) And (TSmallIntArray(ib^)[num]=-1)) Then Begin
			IsBlank:= True;
			Exit
		End Else
			IsBlank:= False;

		p:= BufferOfs(Offset);
		Case getType Of
		fldZSTRING,
		fldWIDESTRING: Begin
			Case PhyType Of
				CWBDB_PCVARSTRING:	 ConvertCP(WordToWord(Word(p^)), BufferOfs(Offset+2), LogLength-1, Value, PhyCP, LogCP, Count, errHandle, ErrorHandler);
				CWBDB_PCVARGRAPHIC:  ConvertCP(WordToWord(Word(p^)), BufferOfs(Offset+2), (LogLength-1)*2, Value, PhyCP, LogCP, Count, errHandle, ErrorHandler);
				CWBDB_PCSTRING: 		 ConvertCP(PhyLength, p, LogLength-1, Value, PhyCP, LogCP, Count, errHandle, ErrorHandler);
				CWBDB_PCGRAPHIC:		 ConvertCP(PhyLength, p, (LogLength-1)*2, Value, PhyCP, LogCP, Count, errHandle, ErrorHandler);
				CWBDB_PCVARDATALINK: ConvertCP(WordToWord(Word(p^)), BufferOfs(Offset+2), LogLength-1, Value, PhyCP, LogCP, Count, errHandle, ErrorHandler);
				CWBDB_PCUNSUPPORTEDTYPE:	Begin StrCopy(Value, szTypeUnsupported); Count:= SizeOf(szTypeUnsupported) End;
			Else
				Result:= DBXERR_INVALIDXLATION;
				Exit
			End;
			If Conn.FTrimChar Then
				While (Count>0) And (PChar(Value)[Count-1]=' ') Do
					Dec(Count);

			PChar(Value)[Count]:= #0
		End;
		fldINT16:
			Case PhyType Of
				CWBDB_PCSHORT:	Word(Value^):= WordToWord(Word(p^));
				CWBDB_PCLONG: 	If OverFlow(IntToInt(Integer(p^)), 16) Then Result:= DBXERR_INVALIDXLATION Else Word(Value^):= IntToInt(Integer(p^));
				CWBDB_PCBIGINT: If OverFlow(BigToBig(Int64(p^)), 32)	 Then Result:= DBXERR_INVALIDXLATION Else Word(Value^):= BigToBig(INT64(p^));
				CWBDB_PCPACKED: Word(Value^):= PackedToInt(TAS400NumericData(p^), Scale, PhyLength);
				CWBDB_PCZONED:	Word(Value^):= ZonedToInt (TAS400NumericData(p^), Scale, PhyLength);
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldINT32:
			Case PhyType Of
				CWBDB_PCSHORT:	Integer(Value^):= WordToWord(Word(p^));
				CWBDB_PCLONG: 	Integer(Value^):= IntToInt(Integer(p^));
				CWBDB_PCBIGINT: If OverFlow(BigToBig(INT64(p^)), 32) Then Result:= DBXERR_INVALIDXLATION Else Integer(Value^):= BigToBig(INT64(p^));
				CWBDB_PCPACKED: Integer(Value^):= PackedToInt(TAS400NumericData(p^), Scale, PhyLength);
				CWBDB_PCZONED:	Integer(Value^):= ZonedToInt (TAS400NumericData(p^), Scale, PhyLength);
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldINT64:
			Case PhyType Of
				CWBDB_PCSHORT:	INT64(Value^):= WordToWord(Word(p^));
				CWBDB_PCLONG: 	INT64(Value^):= IntToInt(Integer(p^));
				CWBDB_PCBIGINT: INT64(Value^):= BigToBig(INT64(p^));
				CWBDB_PCPACKED: INT64(Value^):= PackedToInt64(TAS400NumericData(p^), Scale, PhyLength);
				CWBDB_PCZONED:	INT64(Value^):= ZonedToInt64 (TAS400NumericData(p^), Scale, PhyLength);
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldFLOAT:
			Case PhyType Of
				CWBDB_PCFLOAT:	Double(Value^):= SingleToSingle(Single(p^));
				CWBDB_PCDOUBLE: Double(Value^):= DoubleToDouble(Double(p^));
				CWBDB_PCPACKED: Double(Value^):= PackedToDouble(TAS400NumericData(p^), Scale, PhyLength);
				CWBDB_PCZONED:	Double(Value^):= ZonedToDouble(TAS400NumericData(p^), Scale, PhyLength);
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldBCD:
			Case PhyType Of
				CWBDB_PCPACKED: PackedToBcd(TAS400NumericData(p^), Scale, PhyLength, TInternalBcd(Value^), LogPrecision);
				CWBDB_PCZONED:	ZonedToBcd(TAS400NumericData(p^), Scale, PhyLength, TInternalBcd(Value^), LogPrecision);
				CWBDB_PCBIGINT: Int64ToBcd(BigToBig(INT64(p^)), TInternalBcd(Value^), LogPrecision);
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldDATETIME:
			Case PhyTypeAS400 Of
				CWBDB_SQLTimeStamp,
				CWBDB_SQLTimeStampNC: TSqlTimeStamp(Value^):= AS400ToDateTime(GetStr(PhyLength, p));
			Else
				Result:= DBXERR_INVALIDPARAM
			End;
		fldDATE:
			Case PhyTypeAS400 Of
				CWBDB_SQLDate,
				CWBDB_SQLDateNC: SQLDate(Value^):= AS400ToDate(GetStr(PhyLength, p));
			Else
				Result:= DBXERR_INVALIDPARAM
			End;
		fldTIME:
			Case PhyTypeAS400 Of
				CWBDB_SQLTime,
				CWBDB_SQLTimeNC: SQLTime(Value^):= AS400ToTime(GetStr(PhyLength, p));
			Else
				Result:= DBXERR_INVALIDPARAM
			End;
		fldBLOB:
			Case PhyType Of
				CWBDB_PCBLOB: Move(BufferOfs(Offset+4)^, Value^, Min(IntToInt(Integer(p^)), LogLength));
				CWBDB_PCCLOB: Begin
					ConvertCP(IntToInt(Integer(p^)), BufferOfs(Offset+4), LogLength-1, Value, PhyCP, LogCP, Count, errHandle, ErrorHandler);
					PChar(Value)[Count]:= #0;
				End;

				// CWBDB_PCDBCLOB: Begin End;
				CWBDB_PCBLOBLOCATOR: Begin
					fetchBlob(Item, Cardinal(p^));
					Move(lobData^, Value^, Min(lobLength, LogLength));
				End;
				CWBDB_PCCLOBLOCATOR: Begin
					fetchBlob(Item, Cardinal(p^));
					ConvertCP(lobLength, lobData, LogLength-1, Value, PhyCP, LogCP, Count, errHandle, ErrorHandler);
					PChar(Value)[Count]:= #0;
				End;
				//CWBDB_PCDBCLOBLOCATOR:
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldBYTES: begin
			Move(BufferOfs(Offset)^, Value^, LogLength);
		end;
		Else
			Result:= DBXERR_INVALIDXLATION
		End
	End
end;

function TCA400SQLCommand.setParameter(ulParameter, ulChildPos: Word;
	eParamType: TSTMTParamType; uLogType, uSubType: Word; iPrecision,
	iScale: Integer; iLen: LongWord; pBuffer: Pointer;
	lInd: Integer): SQLResult;
Var
	Item: TColumnParam;
	Index, Count, Dummy: Cardinal;
	SQLCA: cwbDB_SQLCA;
	Locator: Cardinal;
	WideBlank, NativeBlank: WideChar;

	Function pmBufferOfs (Value: Cardinal): Pointer;
	Begin
		Result:= pmDataBuffer+Value
	End;

	Procedure SetStr(Offset, Len: Cardinal; Value: String);
	Begin
		Move(Value[1], Pointer(pmDataBuffer+Offset)^, Min(Len, System.Length(Value)))
	End;

begin
	Result:= DBXERR_NONE;

	// Check for valid param index
	If (ulParameter<1) Or (ulParameter>uParams) Then Begin
		Result:= DBXERR_INVALIDPARAM;
		Exit
	End;

	// because SqlExpr also sets output parameters, we support this

	Index:= ulParameter-1;
	Item:= Params[Index];
	With Item Do Begin
		LogIsNull:= (lInd<>0);
		If LogIsNull Then Begin
			TSmallIntArray(pmindicatorBuffer^)[index]:= -1;
			Exit
		End Else
			TSmallIntArray(pmindicatorBuffer^)[index]:= 0;

		Case uLogType Of
			fldZSTRING,
			fldWIDESTRING: Begin
				// this is a fix for a SqlExpr bug (stored procedure parameters may be shorter (contain 0)
				If FIsStoredProc And (Cardinal(iPrecision)=PhyLength) Then
					iPrecision:= Min(iPrecision, StrLen(pBuffer)); // set iPrecision to length of null term string

				Case PhyType Of
					CWBDB_PCUNSUPPORTEDTYPE: Begin {ignore} End;
					CWBDB_PCVARSTRING: Begin
						ConvertCP(iPrecision, pBuffer, PhyLength-2, pmBufferOfs(Offset+2), LogCP, PhyCP, Count, errHandle, ErrorHandler);
						Word(pmBufferOfs(Offset)^):= WordToWord(Count);
					End;
					CWBDB_PCVARGRAPHIC: Begin
						ConvertCP(iLen-2, pBuffer, PhyLength-2, pmBufferOfs(Offset+2), LogCP, PhyCP, Count, errHandle, ErrorHandler);
						Word(pmBufferOfs(Offset)^):= WordToWord(Count Div 2); // number of characters
					End;
					CWBDB_PCNOCONVERSION,
					CWBDB_PCSTRING:
					begin
						ConvertCP(iPrecision, pBuffer, PhyLength, pmBufferOfs(Offset), LogCP, PhyCP, Count, errHandle, ErrorHandler);
						If Count<PhyLength Then
							FillChar(pmBufferOfs(Offset+Count)^, PhyLength-Count, $40) // EBCDIC space
					end;
					CWBDB_PCGRAPHIC:
					begin
						ConvertCP(iLen-2, pBuffer, Item.PhyLength, pmBufferOfs(Offset), Item.LogCP, Item.PhyCP, Count, errHandle, ErrorHandler);
						If Count<Item.PhyLength-1 Then
						begin
							// create native blank (probably $00 $20)
							WideBlank:= ' ';
							ConvertCP(SizeOf(WideBlank), @WideBlank, SizeOf(NativeBlank), @NativeBlank, Item.LogCP, Item.PhyCP, Dummy, errHandle, ErrorHandler);
							while Count<Item.PhyLength-1 do
							begin
								WideChar(pmBufferOfs(Offset+Count)^):= NativeBlank;
								Inc(Count, SizeOf(WideChar));
							end
						end
					end;
					CWBDB_PCVARDATALINK: Begin
						ConvertCP(iPrecision, pBuffer, PhyLength, pmBufferOfs(Offset+2), LogCP, PhyCP, Count, errHandle, ErrorHandler);
						Word(pmBufferOfs(Offset)^):= WordToWord(Count);
					End;
				Else
					Result:= DBXERR_INVALIDXLATION;
				End;
			End;

		fldINT16:
			Case PhyType Of
				CWBDB_PCZONED:	IntToZoned(Word(pBuffer^), TAS400NumericData(pmBufferOfs(Offset)^), PhyLength);
				CWBDB_PCPACKED: IntToPacked(Word(pBuffer^), TAS400NumericData(pmBufferOfs(Offset)^), PhyLength);
				CWBDB_PCSHORT:	Word(pmBufferOfs(Offset)^):=		WordToWord(Word(pBuffer^));
				CWBDB_PCLONG: 	Integer(pmBufferOfs(Offset)^):= IntToInt(Word(pBuffer^));
				CWBDB_PCBIGINT: Int64(pmBufferOfs(Offset)^):= 	BigToBig(Word(pBuffer^));
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldINT32:
			Case PhyType Of
				CWBDB_PCZONED:	IntToZoned(Integer(pBuffer^), TAS400NumericData(pmBufferOfs(Offset)^), PhyLength);
				CWBDB_PCPACKED: IntToPacked(Integer(pBuffer^), TAS400NumericData(pmBufferOfs(Offset)^), PhyLength);
				CWBDB_PCSHORT:	Begin Word(pmBufferOfs(Offset)^):= WordToWord(Word(pBuffer^)); If Overflow(Integer(pBuffer^), 16) Then Result:= DBXERR_INVALIDXLATION End;
				CWBDB_PCLONG: 	Integer(pmBufferOfs(Offset)^):= IntToInt(Integer(pBuffer^));
				CWBDB_PCBIGINT: Int64(pmBufferOfs(Offset)^):= 	BigToBig(Integer(pBuffer^));
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldINT64:
			Case PhyType Of
				CWBDB_PCZONED:	Int64ToZoned(Int64(pBuffer^), TAS400NumericData(pmBufferOfs(Offset)^), PhyLength);
				CWBDB_PCPACKED: Int64ToPacked(Int64(pBuffer^), TAS400NumericData(pmBufferOfs(Offset)^), PhyLength);
				CWBDB_PCSHORT:	Begin Word(pmBufferOfs(Offset)^):= WordToWord(Word(pBuffer^)); If Overflow(Integer(pBuffer^), 16) Then Result:= DBXERR_INVALIDXLATION End;
				CWBDB_PCLONG: 	Begin Integer(pmBufferOfs(Offset)^):= IntToInt(Integer(pBuffer^)); If Overflow(Int64(pBuffer^), 32) Then Result:= DBXERR_INVALIDXLATION End;
				CWBDB_PCBIGINT: Int64(pmBufferOfs(Offset)^):= BigToBig(INT64(pBuffer^));
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldFLOAT:
			Case PhyType Of
				CWBDB_PCFLOAT:	Single(pmBufferOfs(Offset)^):= SingleToSingle(Double(pBuffer^));
				CWBDB_PCDOUBLE: Double(pmBufferOfs(Offset)^):= DoubleToDouble(Double(pBuffer^));
				CWBDB_PCZONED:	DoubleToZoned(Double(pBuffer^), TAS400NumericData(pmBufferOfs(Offset)^), Scale, PhyLength);
				CWBDB_PCPACKED: DoubleToPacked(Double(pBuffer^), TAS400NumericData(pmBufferOfs(Offset)^), Scale, PhyLength);
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldBCD:
			Case PhyType Of
				CWBDB_PCZONED:	BcdToZoned(TInternalBcd(pBuffer^), TAS400NumericData(pmBufferOfs(Offset)^), Scale, PhyLength);
				CWBDB_PCPACKED: BcdToPacked(TInternalBcd(pBuffer^), TAS400NumericData(pmBufferOfs(Offset)^), Scale, PhyLength);
				CWBDB_PCBIGINT: Int64(pmBufferOfs(Offset)^):= BigToBig(BcdToInt64(TInternalBcd(pBuffer^)));
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldDATETIME:
			Case PhyTypeAS400 Of
				CWBDB_SQLTimeStamp,
				CWBDB_SQLTimeStampNC: SetStr(Offset, PhyLength, DateTimeToAS400(TSqlTimeStamp(pBuffer^)));
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldDATE:
			Case PhyTypeAS400 Of
				CWBDB_SQLDate,
				CWBDB_SQLDateNC: SetStr(Offset, PhyLength, DateToAS400(SQLDate(pBuffer^)));
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldTIME:
			Case PhyTypeAS400 Of
				CWBDB_SQLTime,
				CWBDB_SQLTimeNC: SetStr(Offset, PhyLength, TimeToAS400(SQLTime(pBuffer^)));
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		fldBYTES:
			Move(pBuffer^, pmBufferOfs(Offset)^, PhyLength);
		fldBLOB:
			Case PhyType Of
				CWBDB_PCBLOB: Begin
					Count:= Min(PhyLength-4, iLen);
					Cardinal(pmBufferOfs(Offset)^):= IntToInt(Count);
					Move(pBuffer^, pmBufferOfs(Offset+4)^, Count)
				End;
				CWBDB_PCCLOB: Begin
					ConvertCP(iLen, pBuffer, PhyLength-4, pmBufferOfs(Offset+4), LogCP, PhyCP, Count, errHandle, ErrorHandler);
					Cardinal(pmBufferOfs(Offset)^):= IntToInt(Count);
				End;
				CWBDB_PCBLOBLOCATOR: Begin
					if cwbDB_GetLOBLocator(pmFormatHandle, Num+1, Locator, errHandle)=cwb_OK then
					begin
						cwbDB_ReturnSQLCA(requestHandle, SQLCA, errHandle, ErrorHandler);
						cwbDB_WriteLOBData(requestHandle, pBuffer, Locator, 65535, iLen, 0, errHandle, ErrorHandler);
						Cardinal(pmBufferOfs(Offset)^):= Locator
					end
					else
						Result:= DBXERR_INVALIDXLATION
				End;
				CWBDB_PCCLOBLOCATOR:
					if cwbDB_GetLOBLocator(pmFormatHandle, Num+1, Locator, errHandle)=cwb_OK then
					begin
						ConvertCP(iLen, pBuffer, iLen {in place}, pBuffer, LogCP, PhyCP, Count, errHandle, ErrorHandler);
						cwbDB_ReturnSQLCA(requestHandle, SQLCA, errHandle, ErrorHandler);
						cwbDB_WriteLOBData(requestHandle, pBuffer, Locator, 65535, Count, 0, errHandle, ErrorHandler);
						Cardinal(pmBufferOfs(Offset)^):= Locator
					end
					else
						Result:= DBXERR_INVALIDXLATION
			Else
				Result:= DBXERR_INVALIDXLATION
			End;
		Else
			Result:= DBXERR_INVALIDPARAM
		End
	End
end;

Procedure TCA400SQLCommand.setLogicalTypeInfo (Var Value: TColumnParam);
Begin
	Value.LogPrecision:= Value.Precision;
	Value.LogScale		:= Value.Scale;
	Value.LogLength 	:= Value.PhyLength;
	Value.LogSubType	:= 0;
	Value.LogCP 			:= Conn.FClientCP;

	If Value.isParam Then
		Case Value.PhyDir Of
			CWBDB_PM_INPUT_ONLY:	 Value.ParamType:= paramIN;
			CWBDB_PM_INPUT_OUTPUT: Value.ParamType:= paramINOUT;
			CWBDB_PM_OUTPUT_ONLY:  Value.ParamType:= paramOUT;
		End
	Else
		Value.Searchable:= True;

	Case Value.PhyType Of
		CWBDB_PCUNSUPPORTEDTYPE: Begin
			Value.LogType:= fldZSTRING;
			Value.LogSubType:= fldstFIXED;
			Value.LogLength:= Length(szTypeUnsupported)+1;		//Null terminator
			Value.LogPrecision:= Length(szTypeUnsupported);
			Value.TypeName:= 'CHAR';
		End;
		CWBDB_PCSTRING: Begin
			if Value.PhyCP=CA400_HEXCP then
			begin
				Value.LogType:= fldBYTES;
				Value.TypeName:= 'CHAR FOR BIT DATA';
				Value.LogPrecision:= Value.Scale;
			end
			else
			begin
				if Value.PhyCP=CWBNL_CP_UTF8 then
				begin
					Value.LogType:= fldWIDESTRING;
					Value.LogCP:= CWBNL_CP_UTF16;
				end
				else
				begin
					Value.LogType:= fldZSTRING;
				end;
				Value.LogLength := Value.PhyLength + 1; 	 //Null terminator
				Value.LogSubType:= fldstFIXED;
				Value.LogPrecision:= Value.PhyLength;
				Value.TypeName:= 'CHAR';
			end
		end;
		CWBDB_PCVARSTRING: Begin
			if Value.PhyCP=CA400_HEXCP then
			begin
				Value.LogType:= fldVARBYTES;
				Value.TypeName:= 'VARCHAR FOR BIT DATA';
				Value.LogPrecision:= Value.Scale
			end
			else
			begin
				if Value.PhyCP=CWBNL_CP_UTF8 then
				begin
					Value.LogType:= fldWIDESTRING;
					Value.LogCP:= CWBNL_CP_UTF16;
				end
				else
				begin
					Value.LogType:= fldZSTRING;
				end;
				Value.LogLength:= Value.PhyLength -2 + 1; 	 //Null terminator
				Value.LogPrecision:= Value.Scale;
				if (Value.PhyTypeAS400=CWBDB_SQLLongVaryingString) or (Value.PhyTypeAS400=CWBDB_SQLLongVaryingStringNC) then
					Value.TypeName:= 'LONG VARCHAR'
				else
					Value.TypeName:= 'VARCHAR'
			end
		End;
		CWBDB_PCGRAPHIC: Begin
			Value.LogType:= fldWIDESTRING;
			Value.LogSubType:= fldstFIXED;
			Value.LogLength := Value.PhyLength Div 2 + 1; 	 //Null terminator
			Value.LogPrecision:= Value.Scale;
			Value.LogCP:= CWBNL_CP_UTF16;
			Value.TypeName:= 'GRAPHIC';
		End;
		CWBDB_PCVARGRAPHIC: Begin
			Value.LogType:= fldWIDESTRING;
			Value.LogLength := (Value.PhyLength -2) Div 2 + 1;		//Null terminator
			Value.LogPrecision:= Value.Scale;
			Value.LogCP:= CWBNL_CP_UTF16;
			if (Value.PhyTypeAS400=CWBDB_SQLLongVaryingGraphic) or (Value.PhyTypeAS400=CWBDB_SQLLongVaryingGraphicNC) then
				Value.TypeName:= 'LONG VARGRAPHIC'
			else
				Value.TypeName:= 'VARGRAPHIC';
	 End;
		CWBDB_PCVARDATALINK: Begin										// map DATALINK to String
			Value.LogType:= fldZSTRING;
			Value.LogLength:= Value.PhyLength-2 + 1;		//Null terminator
			Value.LogPrecision:= Value.PhyLength;
			Value.TypeName:= 'DATALINK';
		End;

		CWBDB_PCBIGINT: Begin
			if Conn.FInt64AsBCD then begin
				Value.LogType:= fldBCD;
				Value.LogPrecision:= 20;
				Value.LogScale:= 0;
			end else begin
				Value.LogType:= fldINT64;
				Value.LogPrecision:= sizeof(INT64);
				Value.LogLength 	:= sizeof(INT64);
			end;
			Value.TypeName:= 'BIGINT';
		End;
		CWBDB_PCLONG: Begin
			Value.LogType:= fldINT32;
			Value.LogPrecision:= sizeof(Integer);
			Value.LogLength 	:= sizeof(Integer);
			Value.TypeName:= 'INTEGER';
		End;
		CWBDB_PCSHORT: Begin
			Value.LogType:= fldINT16;
			Value.LogPrecision:= sizeof(SmallInt);
			Value.LogLength 	:= sizeof(SmallInt);
			Value.TypeName:= 'SMALLINT';
		End;
		CWBDB_PCFLOAT: Begin
			Value.LogType:= fldFLOAT;
			Value.LogPrecision:= 4;
			Value.LogLength 	:= sizeof(Double);
			Value.TypeName:= 'REAL';
		End;
		CWBDB_PCDOUBLE: Begin
			Value.LogType:= fldFLOAT;
			Value.LogPrecision:= sizeof(Double);
			Value.LogLength 	:= sizeof(Double);
			Value.TypeName:= 'DOUBLE';
		End;
		CWBDB_PCPACKED,
		CWBDB_PCZONED: Begin
			If Conn.FMapFloat Then Begin
				Value.LogType:= fldFLOAT;
				Value.LogPrecision:= sizeof(Double);
				Value.LogLength 	:= sizeof(Double);
			End Else
				Value.LogType:= fldBCD;
			If (Value.Scale=0) Then
				If Value.Precision<10 Then Begin
					Value.LogType:= fldINT32;
					Value.LogPrecision:= sizeof(Integer);
					Value.LogLength 	:= sizeof(Integer);
				End Else Begin
					Value.LogType:= fldINT64;
					Value.LogPrecision:= sizeof(Int64);
					Value.LogLength 	:= sizeof(Int64);
				End;
			If Value.PhyType=CWBDB_PCPACKED Then
				Value.TypeName:= 'DECIMAL'
			Else
				Value.TypeName:= 'NUMERIC'
		End;
		CWBDB_PCBLOB: Begin
			Value.LogType:= fldBLOB;
			Value.LogPrecision:= 1;
			Value.LogSubType:= fldstBINARY;
			Value.Searchable:= FALSE;
			Value.LogLength:= Value.PhyLength-4;
			Value.TypeName:= 'BLOB';
		End;
		CWBDB_PCBLOBLOCATOR: Begin
			Value.LogType:= fldBLOB;
			Value.LogPrecision:= 1;
			Value.LogSubType:= fldstBINARY;
			Value.Searchable:= FALSE;
			Value.LogLength:= Value.PhyLOBLength;
			Value.TypeName:= 'BLOB';
		End;
		CWBDB_PCCLOB: Begin
			Value.LogType:= fldBLOB;
			Value.LogPrecision:= 1;
			Value.LogSubType:= fldstMEMO;
			Value.Searchable:= FALSE;
			Value.LogLength:= Value.PhyLength-4;
			Value.TypeName:= 'CLOB';
		End;
		CWBDB_PCCLOBLOCATOR: Begin
			Value.LogType:= fldBLOB;
			Value.LogPrecision:= 1;
			Value.LogSubType:= fldstMEMO;
			Value.Searchable:= FALSE;
			Value.LogLength:= Value.PhyLOBLength;
			Value.TypeName:= 'CLOB';
		End;
		CWBDB_PCDBCLOB: Begin 				// Double Byte CLOB
			Value.LogType:= fldBLOB;
			Value.LogPrecision:= 1;
			Value.LogSubType:= fldstHMEMO;		 // ????
			Value.Searchable:= FALSE;
			Value.LogLength:= (Value.PhyLength-4) Div 2;
			Value.TypeName:= 'DBCLOB';
		End;
		CWBDB_PCDBCLOBLOCATOR: Begin
			Value.LogType:= fldBLOB;
			Value.LogPrecision:= 1;
			Value.LogSubType:= fldstHMEMO;		 // ????
			Value.Searchable:= FALSE;
			Value.LogLength:= (Value.PhyLOBLength) Div 2;
			Value.TypeName:= 'DBCLOB';
		End;
	Else
		Value.LogType:= fldUNKNOWN;
	End;

	// further cases not detected through uPhyType, but uPhyTypeAS400:
	Case Value.PhyTypeAS400 Of
		CWBDB_SQLDate,
		CWBDB_SQLDateNC: Begin
			Value.LogType:= fldDATE;
			Value.LogLength:= sizeof(SQLDate);
			Value.TypeName:= 'DATE';
		End;
		CWBDB_SQLTime,
		CWBDB_SQLTimeNC: Begin
			Value.LogType:= fldTIME;
			Value.LogLength:= SizeOf(SQLTime);
			Value.TypeName:= 'TIME';
		End;
		CWBDB_SQLTimeStamp,
		CWBDB_SQLTimeStampNC: Begin
			Value.LogType:= fldDATETIME;
			Value.LogLength:= sizeof(TSqlTimeStamp);
			Value.TypeName:= 'TIMESTAMP';
		End;
	End
End;

function TCA400SQLCommand.Trace(const Value: String): Boolean;
begin
	Result:= Conn.Trace(Value)
end;

function TCA400SQLCommand.Trace(const Value: String; Items: array of Const): Boolean;
begin
	Result:= Conn.Trace(Value, Items)
end;

// AS/400 Zoned to Double

Function TCA400SQLCommand.ZonedToDouble (Const data: TAS400NumericData; Scale, Width: Integer): Double;
Var
	i: Integer;
Begin
	Result:= 0.0;
	If Width<=0 Then
		Exit;
	For i:= 0 To Width-1 Do
		Result:= Result*10.0 + (data[i] And $0F);
	If data[width-1] And $F0 = FlagZonedNeg Then // Negative?
		Result:= -Result;
	For i:= 1 To Scale Do  // Adjust for scale factor, if any
		Result:= Result/10.0
End;

Function TCA400SQLCommand.PackedToDouble (Const data: TAS400NumericData; Scale, Width: Integer): Double;
Var
	i: Integer;
Begin
	Result:= 0.0;
	If Width<=0 Then
		Exit;
	For i:= 0 To Width-2 Do
		Result:= Result*100.0 + (data[i] Shr 4)*10.0
													+ (data[i] And $0F);

	Result:= Result*10.0 + (data[width-1] Shr 4);
	If data[width-1] And $0F = FlagPackedNeg Then
		Result:= -Result;
	For i:= 1 To Scale Do
		Result:= Result/10.0
End;

// normally Scale should be 0 for this call!
Function TCA400SQLCommand.ZonedToInt (Const data: TAS400NumericData; Scale, Width: Integer): Integer;
Var
	i: Integer;
Begin
	Result:= 0;
	If Width<=0 Then
		Exit;
	For i:= 0 To Width-1 Do
		Result:= Result*10 + (data[i] And $0F);
	If data[width-1] And $F0 = FlagZonedNeg Then // Negative?
		Result:= -Result;
	For i:= 1 To Scale Do  // Adjust for scale factor, if any
		Result:= Result Div 10
End;

// normally Scale should be 0 for this call!
Function TCA400SQLCommand.PackedToInt (Const data: TAS400NumericData; Scale, Width: Integer): Integer;
Var
	i: Integer;
Begin
	Result:= 0;
	If Width<=0 Then
		Exit;
	For i:= 0 To Width-2 Do
		Result:= Result*100 + (data[i] Shr 4)*10
												+ (data[i] And $0F);

	Result:= Result*10 + (data[width-1] Shr 4);
	If data[width-1] And $0F = FlagPackedNeg Then
		Result:= -Result;
	For i:= 1 To Scale Do
		Result:= Result Div 10
End;

// normally Scale should be 0 for this call!
Function TCA400SQLCommand.ZonedToInt64 (Const data: TAS400NumericData; Scale, Width: Integer): Int64;
Var
	i: Integer;
Begin
	Result:= 0;
	If Width<=0 Then
		Exit;
	For i:= 0 To Width-1 Do
		Result:= Result*10 + (data[i] And $0F);
	If data[width-1] And $F0 = FlagZonedNeg Then // Negative?
		Result:= -Result;
	For i:= 1 To Scale Do  // Adjust for scale factor, if any
		Result:= Result Div 10
End;

// normally Scale should be 0 for this call!
Function TCA400SQLCommand.PackedToInt64 (Const data: TAS400NumericData; Scale, Width: Integer): Int64;
Var
	i: Integer;
Begin
	Result:= 0;
	If Width<=0 Then
		Exit;
	For i:= 0 To Width-2 Do
		Result:= Result*100 + (data[i] Shr 4)*10
												+ (data[i] And $0F);

	Result:= Result*10 + (data[width-1] Shr 4);
	If data[width-1] And $0F = FlagPackedNeg Then
		Result:= -Result;
	For i:= 1 To Scale Do
		Result:= Result Div 10
End;

Procedure TCA400SQLCommand.DoubleToZoned (Value: Double; Var data: TAS400NumericData; Scale, Width: Integer);
Var
	i: Integer;
Begin
	For i:= 1 To Scale Do
		Value:= Value*10.0;
	i:= Width-1;
	Value:= Round(Value)/10.0;
	If Value<0 Then Begin
		Value:= -Value;
		data[i]:= Trunc(Frac(Value)*10.0) Or FlagZonedNeg
	End Else
		data[i]:= Trunc(Frac(Value)*10.0) Or FlagZonedPos;
	While (i>0) Do Begin
		Value:= Value/10.0;
		Dec(i);
		data[i]:= Trunc(Frac(Value)*10.0) Or FlagZonedPos
	End
End;

Procedure TCA400SQLCommand.DoubleToPacked (Value: Double; Var data: TAS400NumericData; Scale, Width: Integer);
Var
	i: Integer;
	b: Byte;
Begin
	For i:= 1 To Scale Do
		Value:= Value*10.0;
	i:= Width-1;
	Value:= Round(Value)/10.0;
	If Value<0 Then Begin
		Value:= -Value;
		data[i]:= Trunc(Frac(Value)*10.0) Shl 4 Or FlagPackedNeg
	End Else
		data[i]:= Trunc(Frac(Value)*10.0) Shl 4 Or FlagPackedPos;

	While (i>0) Do Begin
		Value:= Value/10.0;
		Dec(i);
		b:= Trunc(Frac(Value)*10.0);
		Value:= Value/10.0;
		data[i]:= b Or Trunc(Frac(Value)*10.0) Shl 4
	End
End;

Procedure TCA400SQLCommand.IntToZoned (Value: Integer; Var data: TAS400NumericData; Width: Integer);
Var
	i: Integer;
Begin
	i:= Width-1;
	If Value<0 Then Begin
		Value:= -Value;
		data[i]:= (Value Mod 10) Or FlagZonedNeg
	End Else
		data[i]:= (Value Mod 10) Or FlagZonedPos;
	While (i>0) Do Begin
		Value:= Value Div 10;
		Dec(i);
		data[i]:= (Value Mod 10) Or FlagZonedPos
	End
End;

Procedure TCA400SQLCommand.IntToPacked (Value: Integer; Var data: TAS400NumericData; Width: Integer);
Var
	i: Integer;
	b: Byte;
Begin
	i:= Width-1;
	If Value<0 Then Begin
		Value:= -Value;
		data[i]:= ((Value Mod 10) Shl 4) Or FlagPackedNeg
	End Else
		data[i]:= ((Value Mod 10) Shl 4) Or FlagPackedPos;
	While i>0 Do Begin
		Value:= Value Div 10;
		Dec(i);
		b:= (Value Mod 10);
		Value:= Value Div 10;
		data[i]:= b Or (Value Mod 10) Shl 4
	End
End;

Procedure TCA400SQLCommand.Int64ToZoned (Value: Int64; Var data: TAS400NumericData; Width: Integer);
Var
	i: Integer;
Begin
	i:= Width-1;
	If Value<0 Then Begin
		Value:= -Value;
		data[i]:= (Value Mod 10) Or FlagZonedNeg
	End Else
		data[i]:= (Value Mod 10) Or FlagZonedPos;
	While (i>0) Do Begin
		Value:= Value Div 10;
		Dec(i);
		data[i]:= (Value Mod 10) Or FlagZonedPos
	End
End;

Procedure TCA400SQLCommand.Int64ToPacked (Value: Int64; Var data: TAS400NumericData; Width: Integer);
Var
	i: Integer;
	b: Byte;
Begin
	i:= Width-1;
	If Value<0 Then Begin
		Value:= -Value;
		data[i]:= ((Value Mod 10) Shl 4) Or FlagPackedNeg
	End Else
		data[i]:= ((Value Mod 10) Shl 4) Or FlagPackedPos;
	While i>0 Do Begin
		Value:= Value Div 10;
		Dec(i);
		b:= (Value Mod 10);
		Value:= Value Div 10;
		data[i]:= b Or (Value Mod 10) Shl 4
	End
End;

Procedure TCA400SQLCommand.Int64ToBcd (Value: Int64; Var Bcd: TInternalBcd; Precision: Byte);
var
	data: TAS400NumericData;
begin
	Int64ToZoned(Value, data, Precision);
	ZonedToBcd(data, 0, Precision, Bcd, Precision);
end;

Procedure TCA400SQLCommand.ZonedToBcd (Const data: TAS400NumericData; scale, width: Integer; Var Bcd: TInternalBcd; Precision: Byte);
Var
	i: Integer;
	bi: Integer;
Begin
	FillChar(Bcd.Fraction, 0, SizeOf(Bcd.Fraction));
	bi:= 0;
	For i:= 0 To Width-1 Do
		If Odd(i) Then Begin
			Bcd.Fraction[bi]:= Bcd.Fraction[bi] Or (data[i] And $0F);
			Inc(bi)
		End Else
			Bcd.Fraction[bi]:= (data[i] And $0F) Shl 4;

	// Set precision, sign, and scale (ignore special (ie. set to 0)).
	Bcd.Precision:= Precision;
	Bcd.SignSpecialPlaces:= scale;
	If data[width-1] And $F0 = FlagZonedNeg Then // negative ?
		Bcd.SignSpecialPlaces:= Bcd.SignSpecialPlaces Or $80
End;

Procedure TCA400SQLCommand.PackedToBcd (Const data: TAS400NumericData; scale, width: Integer; Var Bcd: TInternalBcd; Precision: Byte);
Var
	bi: Integer;
Begin
	FillChar(Bcd.Fraction, 0, SizeOf(Bcd.Fraction));
	If Odd(Precision) Then
		For bi:= 0 To Width-1 Do
			Bcd.Fraction[bi]:= data[bi]
	Else
		For bi:= 0 To Width-2 Do
			Bcd.Fraction[bi]:= ((data[bi] And $0F) Shl 4)
											Or ((data[bi+1] And $F0) Shr 4);

	// Set precision, sign, and scale (ignore special (ie. set to 0)).
	Bcd.Precision:= Precision;
	Bcd.SignSpecialPlaces:= scale;
	If data[width-1] And $0F = FlagPackedNeg Then // negative ?
		Bcd.SignSpecialPlaces:= Bcd.SignSpecialPlaces Or $80
End;

Procedure TCA400SQLCommand.BcdToZoned (Const Bcd: TInternalBcd; Var data: TAS400NumericData; scale, width: Integer);
Var
	i, bi: Integer;
Begin
	i:= 0;
	bi:= 0;
	If Bcd.Precision>Width Then
		bi:= (Bcd.Precision-(Bcd.SignSpecialPlaces And $3F))-(Width-Scale)
	Else
		If Bcd.Precision<Width Then Begin
			i:= (Width-Scale)-(Bcd.Precision-(Bcd.SignSpecialPlaces And $3F));
			FillChar(data,i,FlagZonedPos)
		End;
	While i<Width Do Begin
		If Odd(bi) Then
			data[i]:= (Bcd.Fraction[bi Shr 1] And $0F) Or FlagZonedPos
		Else
			data[i]:= (Bcd.Fraction[bi Shr 1] Shr 4) Or FlagZonedPos;
		Inc(i);
		Inc(bi)
	End;
	If Bcd.SignSpecialPlaces And $80 <> 0 Then
		data[width-1]:= (data[width-1] and $0F) Or FlagZonedNeg
End;

Function TCA400SQLCommand.BcdToInt64 (Const Bcd: TInternalBcd): Int64;
var
	data: TAS400NumericData;
begin
	BcdToZoned(Bcd, data, 0, 20);
	Result:= ZonedToInt64(data, 0, 20)
end;

Procedure TCA400SQLCommand.BcdToPacked (Const Bcd: TInternalBcd; Var data: TAS400NumericData; scale, width: Integer);
Var
	i, bi, dataprecision: Integer;
	b: Byte;
Begin
	i:= 0;
	bi:= 0;
	dataprecision:= width*2-1;
	If Bcd.Precision>dataprecision Then
		bi:= (Bcd.Precision-(Bcd.SignSpecialPlaces And $3F))-(dataprecision-scale)
	Else
		If Bcd.Precision<dataprecision Then Begin
			i:= (dataprecision-scale)-(Bcd.Precision-(Bcd.SignSpecialPlaces And $3F));
			FillChar(data,i shr 1,0)
		End;
	While i<dataprecision Do Begin
		If Odd(bi) Then
			b:= Bcd.Fraction[bi Shr 1] And $0F
		Else
			b:= Bcd.Fraction[bi Shr 1] Shr 4;
		If Odd(i) Then
			data[i Shr 1]:= data[i Shr 1] Or b
		Else
			data[i Shr 1]:= b Shl 4;
		Inc(i);
		Inc(bi)
	End;
	If Bcd.SignSpecialPlaces And $80 <> 0 Then
		data[width-1]:= (data[width-1] and $F0) Or FlagPackedNeg
	Else
		data[width-1]:= (data[width-1] and $F0) Or FlagPackedPos
End;

Function TCA400SQLCommand.DateTimeToAS400 (Value: TSqlTimeStamp): String;
Var
	Count: Cardinal;
Begin
	Result:= Format('%04.4d-%02.2d-%02.2d-%02.2d.%02.2d.%02.2d.%03.3d%03.3d',
		[Value.Year, Value.Month, Value.Day, Value.Hour, Value.Minute, Value.Second,
		 Value.Fractions And $FFFF, Value.Fractions shr 16]);

	ConvertCP(Length(Result), PChar(Result), Length(Result), PChar(Result), Conn.FClientCP {1252}, 37, Count, errHandle, ErrorHandler);
End;

Function TCA400SQLCommand.DateToAS400 (Value: SQLDate): String;
Var
	Year, Month, Day: Word;
	Count: Cardinal;
Begin
	DecodeDate(Value-DateDelta, Year, Month, Day);
	Result:= Format('%04.4d-%02.2d-%02.2d', [Year, Month, Day]);
	ConvertCP(Length(Result), PChar(Result), Length(Result), PChar(Result), Conn.FClientCP {1252}, 37, Count, errHandle, ErrorHandler);
End;

Function TCA400SQLCommand.TimeToAS400 (Value: SQLTime): String;
Var
	Hour, Minute, Second: Word;
	Count: Cardinal;
Begin
	Value:= Value Div 1000; Second:= Value Mod 60;
	Value:= Value Div 60; 	Minute:= Value Mod 60;
	Hour:= Value Div 60;
	Result:= Format('%02.2d.%02.2d.%02.2d', [Hour, Minute, Second]);
	ConvertCP(Length(Result), PChar(Result), Length(Result), PChar(Result), Conn.FClientCP {1252}, 37, Count, errHandle, ErrorHandler);
End;

Function TCA400SQLCommand.AS400ToDateTime (Value: String): TSqlTimeStamp;
Var
	Count: Cardinal;
Begin
	ConvertCP(Length(Value), PChar(Value), Length(Value), PChar(Value), 37, Conn.FClientCP {1252}, Count, errHandle, ErrorHandler);
	Result.Year:=  StrToIntDef(Copy(Value, 1, 4), 2000);
	Result.Month:= StrToIntDef(Copy(Value, 6, 2), 1);
	Result.Day:=	 StrToIntDef(Copy(Value, 9, 2), 1);
	Result.Hour:=  StrToIntDef(Copy(Value, 12, 2), 0);
	Result.Minute:= StrToIntDef(Copy(Value, 15,2), 0);
	Result.Second:= StrToIntDef(Copy(Value, 18, 2), 0);
	Result.Fractions:= StrToIntDef(Copy(Value, 21, 3), 0)
									 + StrToIntDef(Copy(Value, 24, 3), 0) Shl 16
End;

Function TCA400SQLCommand.AS400ToDate (Value: String): SQLDate;
Var
	Count: Cardinal;
Begin
	ConvertCP(Length(Value), PChar(Value), Length(Value), PChar(Value), 37, Conn.FClientCP {1252}, Count, errHandle, ErrorHandler);
	Result:= DateDelta+ Trunc(
					 EncodeDate(StrToIntDef(Copy(Value, 1, 4), 2000),
											StrToIntDef(Copy(Value, 6, 2), 1),
											StrToIntDef(Copy(Value, 9, 2), 1)))
End;

Function TCA400SQLCommand.AS400ToTime (Value: String): SQLTime;
Var
	Count: Cardinal;
Begin
	ConvertCP(Length(Value), PChar(Value), Length(Value), PChar(Value), 37, Conn.FClientCP {1252}, Count, errHandle, ErrorHandler);
	Result:= ((StrToIntDef(Copy(Value, 1, 2), 0)*60
						+StrToIntDef(Copy(Value, 4, 2), 0))*60
						+StrToIntDef(Copy(Value, 7, 2), 0))*1000
End;

Function TCA400SQLCommand.IntToInt (Value: Integer): Integer;
Type
	TFourBytes = Array[0..3] Of Byte;
Begin
	TFourBytes(Result)[0]:= TFourBytes(Value)[3];
	TFourBytes(Result)[1]:= TFourBytes(Value)[2];
	TFourBytes(Result)[2]:= TFourBytes(Value)[1];
	TFourBytes(Result)[3]:= TFourBytes(Value)[0]
End;

function TCA400SQLCommand.WordToWord(Value: Word): Word;
begin
	Result:= Lo(Value) Shl 8 Or Hi(Value)
end;

function TCA400SQLCommand.DoubleToDouble(Value: Double): Double;
Type
	TEightBytes = Array[0..7] Of Byte;
Begin
	TEightBytes(Result)[0]:= TEightBytes(Value)[7];
	TEightBytes(Result)[1]:= TEightBytes(Value)[6];
	TEightBytes(Result)[2]:= TEightBytes(Value)[5];
	TEightBytes(Result)[3]:= TEightBytes(Value)[4];
	TEightBytes(Result)[4]:= TEightBytes(Value)[3];
	TEightBytes(Result)[5]:= TEightBytes(Value)[2];
	TEightBytes(Result)[6]:= TEightBytes(Value)[1];
	TEightBytes(Result)[7]:= TEightBytes(Value)[0];
End;

function TCA400SQLCommand.BigToBig(Value: INT64): INT64;
Type
	TEightBytes = Array[0..7] Of Byte;
Begin
	TEightBytes(Result)[0]:= TEightBytes(Value)[7];
	TEightBytes(Result)[1]:= TEightBytes(Value)[6];
	TEightBytes(Result)[2]:= TEightBytes(Value)[5];
	TEightBytes(Result)[3]:= TEightBytes(Value)[4];
	TEightBytes(Result)[4]:= TEightBytes(Value)[3];
	TEightBytes(Result)[5]:= TEightBytes(Value)[2];
	TEightBytes(Result)[6]:= TEightBytes(Value)[1];
	TEightBytes(Result)[7]:= Byte(Value); // do it this way because of D6 compiler bug
End;

function TCA400SQLCommand.SingleToSingle(Value: Single): Single;
Type
	TFourBytes = Array[0..3] Of Byte;
Begin
	TFourBytes(Result)[0]:= TFourBytes(Value)[3];
	TFourBytes(Result)[1]:= TFourBytes(Value)[2];
	TFourBytes(Result)[2]:= TFourBytes(Value)[1];
	TFourBytes(Result)[3]:= TFourBytes(Value)[0]
End;

{ TCA400SQLCursor }

constructor TCA400SQLCursor.Create(AOwner: TCA400SqlCommand);
begin
	Inherited Create;
	FCommand:= AOwner;
end;

destructor TCA400SQLCursor.Destroy;
begin
	If Assigned(FCommand) Then
		Command.Close;
	inherited;
end;

function TCA400SQLCursor.getBcd(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then With Cols[ColumnNumber-1] Do
		Result:= Command.GetData(fldBCD, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.getBlob(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool; Length: LongWord): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldBLOB, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.getBlobSize(ColumnNumber: Word;
	var Length: LongWord; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then With Cols[ColumnNumber-1] Do
		Result:= Command.GetSize(fldBLOB, Cols[ColumnNumber-1], Length, IsBlank)
end;

function TCA400SQLCursor.getBytes(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldBYTES, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.GetCols: TColumnParams;
begin
	Result:= Command.Cols
end;

function TCA400SQLCursor.getColumnCount(var pColumns: Word): SQLResult;
begin
	pColumns:= Command.uColumns;
	Result:= DBXERR_NONE
end;

function TCA400SQLCursor.getColumnLength(ColumnNumber: Word; var pLength: LongWord): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then With Cols[ColumnNumber-1] Do
		pLength:= LogLength
end;

function TCA400SQLCursor.getColumnName(ColumnNumber: Word; pColumnName: PWideChar): SQLResult;
begin
	if checkColumn(Result, ColumnNumber) then with Cols[ColumnNumber-1] Do
		WStrPCopy(pColumnName, Name)
end;

function TCA400SQLCursor.getColumnNameLength(ColumnNumber: Word; var pLen: Word): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then With Cols[ColumnNumber-1] Do
		pLen:= Length(Name)+1
end;

function TCA400SQLCursor.getColumnPrecision(ColumnNumber: Word; var piPrecision: SmallInt): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then With Cols[ColumnNumber-1] Do
		piPrecision:= LogPrecision
end;

function TCA400SQLCursor.getColumnScale(ColumnNumber: Word; var piScale: SmallInt): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then With Cols[ColumnNumber-1] Do
		piScale:= LogScale
end;

function TCA400SQLCursor.getColumnType(ColumnNumber: Word; var puType, puSubType: Word): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then With Cols[ColumnNumber-1] Do Begin
		puType:= LogType;
		puSubType:= LogSubType;
	End
end;

function TCA400SQLCursor.GetCommand: TCA400SQLCommand;
begin
	If FCommand=Nil Then
		Raise ECA400InvalidCommand.Create('Invalid command object')
	Else
		Result:= FCommand
end;

function TCA400SQLCursor.getDouble(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldFLOAT, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.getErrorMessage: WideString;
begin
	Result:= Command.getErrorMessage
end;

function TCA400SQLCursor.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin
	Result:= Command.getErrorMessageLen(ErrorLen)
end;

function TCA400SQLCursor.getLong(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldINT32, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.getInt64(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldINT64, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.GetOption(eOption: TSQLCursorOption;
	PropValue: Pointer; MaxLength: SmallInt;
	out Length: SmallInt): SQLResult;
begin
	Result:= DBXERR_NONE
end;

function TCA400SQLCursor.getShort(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldINT16, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.getString(ColumnNumber: Word; Value: PChar; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldZSTRING, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.getWideString(ColumnNumber: Word; Value: PWideChar; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldWIDESTRING, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.getDate(ColumnNumber: Word; Value: Pointer;
	var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldDATE, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.getTime(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldTIME, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.getTimeStamp(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Result:= Command.GetData(fldDATETIME, Cols[ColumnNumber-1], Value, IsBlank);
end;

function TCA400SQLCursor.isAutoIncrement(ColumnNumber: Word; var AutoIncr: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		AutoIncr:= False
end;

function TCA400SQLCursor.isBlobSizeExact(ColumnNumber: Word; var IsExact: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then With Cols[ColumnNumber-1] Do
		IsExact:= Cols[ColumnNumber-1].PhyType in [CWBDB_PCBLOB, CWBDB_PCCLOB, CWBDB_PCDBCLOB]
end;

function TCA400SQLCursor.isNullable(ColumnNumber: Word; var Nullable: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then With Cols[ColumnNumber-1] Do
		Nullable:= (PhyTypeAS400 And 1) = 1
end;

function TCA400SQLCursor.isReadOnly(ColumnNumber: Word; var ReadOnly: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then With Cols[ColumnNumber-1] Do
		ReadOnly:= False
end;

function TCA400SQLCursor.isSearchable(ColumnNumber: Word; var Searchable: LongBool): SQLResult;
begin
	If checkColumn(Result, ColumnNumber) Then
		Searchable:= Cols[ColumnNumber-1].Searchable
end;

function TCA400SQLCursor.next: SQLResult;
begin
	Result:= Command.fetch
end;

function TCA400SQLCursor.SetOption(eOption: TSQLCursorOption; PropValue: Integer): SQLResult;
begin
	Result:= DBXERR_NONE
end;

function TCA400SQLCursor.CheckColumn(var Res: SQLResult; Index: Word): Boolean;
begin
	If (Index>0) And (Index<=Command.uColumns) Then
		Res:= DBXERR_NONE
	Else
		Res:= DBXERR_OUTOFRANGE;
	Result:= Res=DBXERR_NONE
end;

function TCA400SQLCursor.GetConn: TCA400SQLConnection;
begin
	Result:= Command.Conn
end;

{ TCA400SQLMetaData }

constructor TCA400SQLMetaData.Create(AOwner: TCA400SqlConnection);
begin
	Inherited Create;
	FConnection:= AOwner;
end;

destructor TCA400SQLMetaData.Destroy;
begin
	inherited;
end;

function TCA400SQLMetaData.GetConn: TCA400SQLConnection;
begin
	If FConnection=Nil Then
		Raise ECA400InvalidConnection.Create('Invalid connection')
	Else
		Result:= FConnection
end;

function TCA400SQLMetaData.getErrorMessage: WideString;
begin
	Result:= Conn.getErrorMessage
end;

function TCA400SQLMetaData.getErrorMessageLen(out ErrorLen: SmallInt): SQLResult;
begin
	Result:= Conn.getErrorMessageLen(ErrorLen)
end;

function TCA400SQLMetaData.GetOption(eDOption: TSQLMetaDataOption; PropValue: Pointer; MaxLength: SmallInt; out Len: SmallInt): SQLResult;
	procedure SetStr (Const Value: WideString);
	begin
		Len:= 0;
		if (MaxLength>0) and (PropValue<>Nil) then
			if Conn.FExpectWide then
			begin
				WStrLCopy(PropValue, PWideChar(Value), MaxLength div sizeof(widechar));
				Len:= WStrLen(PropValue)
			end
			else
			begin
				StrLCopy(PropValue, PAnsiChar(AnsiString(Value)), MaxLength);
				Len:= StrLen(PropValue)
			end
	end;

begin
	Result:= DBXERR_NONE;
	Case eDOption Of
		eMetaDatabaseName:				Result:= Conn.getOption(eConnDatabaseName, PropValue, MaxLength, Len);
		eMetaDatabaseVersion: 		Result:= Conn.getOption(eConnServerVersion, PropValue, MaxLength, Len);
		eMetaTransactionIsoLevel: Result:= Conn.getOption(eConnTxnIsoLevel, PropValue, MaxLength, Len);
		eMetaSupportsTransaction: Begin Len:= SizeOf(LongBool); LongBool(PropValue^):= True End;
		eMetaSupportsTransactions:Begin Len:= SizeOf(LongBool); LongBool(PropValue^):= False End;
		eMetaMaxColumnsInTable: 	Begin Len:= SizeOf(Integer); Integer(PropValue^):= 0 End;
		eMetaMaxRowSize:					Begin Len:= SizeOf(Integer); Integer(PropValue^):= 0 End;
		eMetaProcSupportsCursor:	Begin Len:= SizeOf(LongBool); LongBool(PropValue^):= True End;
		eMetaProcSupportsCursors: Begin Len:= SizeOf(LongBool); LongBool(PropValue^):= False End;
		eMetaObjectQuoteChar: 		SetStr('"');
		eMetaCatalogName: 				SetStr(WMetaCatalogName);
		eMetaSchemaName:					SetStr(WMetaSchemaName);
{$If RTLVersion >= 15.00}
		eMetaPackageName: 				SetStr(WMetaPackageName);
{$IfEnd}
{$If RTLVersion >= 17.00}
		eMetaDefaultSchemaName: 	SetStr(''); // return empty default schema name
{$IfEnd}
	Else
		Result:= DBXERR_NOTSUPPORTED
	End
end;

function TCA400SQLMetaData.SetOption(eDOption: TSQLMetaDataOption; PropValue: Integer): SQLResult;
	function GetStr: WideString;
	begin
		if Conn.FExpectWide then
			Result:= PWideChar(PropValue)
		else
			Result:= AnsiString(PAnsiChar(PropValue))
	end;

begin
	Result:= DBXERR_NONE;
	Case eDOption Of
		eMetaCatalogName:  WMetaCatalogName:=  Unquote(GetStr);
		eMetaSchemaName:	 WMetaSchemaName:=	 Unquote(GetStr);
		eMetaDatabaseName: WMetaDataBaseName:= Unquote(GetStr);
{$If RTLVersion >= 15.00}
		eMetaPackageName:  WMetaPackageName:=  UnQuote(GetStr); 	// SqlExpr uses this only for Oracle and Stored Procedures
{$IfEnd}
	End
end;

Function TCA400SQLMetaData.ExecuteQuery(Value: WideString; Const Columns: Array Of WideString; MaxRec: Integer = 0): SQLResult;
Var
	Command: TCA400SQLCommand;
	i: Integer;
	S: WideString;
	DoQuote: Boolean;
Begin
	FMDCursor:= Nil;
	If Conn.Qualifier<>'.' Then Begin
		Value:= StringReplace(Value, 'QSYS.', 'QSYS'+Conn.Qualifier, [rfReplaceAll]);
		Value:= StringReplace(Value, 'QSYS2.', 'QSYS2'+Conn.Qualifier, [rfReplaceAll]);
	End;
	Command:= TCA400SQLCommand.Create(Conn);
	Command.FDirectQuery:= True; // will not be re-executed!
	Result:= Command.Prepare(PWideChar(Value), 0);
	If Result=DBXERR_NONE Then Begin
		FMDCursor:= TCA400SQLMetaDataCursor.Create(Command);
		Try
			MDCursor.FMaxRec:= MaxRec;
			DoQuote:= Conn.FFullQuoting;
			If WMetaSchemaName<>'' Then
				MDCursor.WDefaultSchema:= WMetaSchemaName
			Else
				If Conn.WRole<>'' Then
					MDCursor.WDefaultSchema:= Conn.WRole
				Else
					MDCursor.WDefaultSchema:= Conn.WUser;

			Command.Open;
			For i:= 0 To Min(High(Columns), High(Command.Cols)) Do Begin
				S:= Columns[i];
				Command.Cols[i].Name:= S;
				If DoQUote Then Begin
					If S='SCHEMA_NAME' Then MDCursor.FSchemaColumn:= i+1
					Else If (S='TABLE_NAME') Or (S='PROC_NAME') Then Begin
						MDCursor.FObjColumn:= i+1;
						Command.Cols[i].LogScale:= 64;
						Command.Cols[i].LogPrecision:= 64
					End
				End;
				If Pos('_DATATYPE', S)>0 Then MDCursor.FDataTypeColumn:= i+1 Else
				If Pos('_TYPENAME', S)>0 Then MDCursor.FTypeNameColumn:= i+1 Else
				If Pos('_SUBTYPE', S)>0 Then MDCursor.FSubTypeColumn:= i+1 Else
				If Pos('_PRECISION', S)>0 Then MDCursor.FPrecisionColumn:= i+1 Else
				If Pos('_SCALE', S)>0 Then MDCursor.FScaleColumn:= i+1 Else
				If S='ORD' Then MDCursor.FOrdColumn:= i+1
			End
		Except
			FreeAndNil(Command);
			FreeAndNil(FMDCursor);
			Raise
		End
	End
End;

function TCA400SQLMetaData.GetTables(CatalogName, OwnerName, ObjectName: PWideChar; TableType: LongWord): SQLResult;
Const
	Columns: Array[0..4] Of WideString = ('RECNO', 'CATALOG_NAME', 'SCHEMA_NAME', 'TABLE_NAME', 'TABLE_TYPE');
Var
	Q, InStr: WideString;
Begin
	InStr:= '';
	If TableType And (eSQLTable Or eSQLSystemTable)<>0 Then Begin
		AddInStr(InStr, Cite('TB'));
		AddInStr(InStr, Cite('PF'))
	End;
	If TableType And eSQLView<>0 Then
		AddInStr(InStr, Cite('VW'));
	Q:= 'select 1, dbxdic, dbxlib, dbxlfi, case dbxatr when ''PF'' then ''TABLE'' when ''VW'' then ''VIEW'' else ''SYSTEM TABLE'' end from QSYS.QADBXATR where dbxrel=''Y''';
	AddQueryItem(Q, 'dbxatr', InStr);
	AddQueryItem(Q, 'dbxlib', ExpandSchemas(Unquote(OwnerName)));
	AddQueryItem(Q, 'dbxlfi', Cite(Unquote(ObjectName)));
	Q:= Q+' order by dbxlib, dbxlfi';
	Result:= ExecuteQuery(Q, Columns, Conn.FLIMITMD)
End;

function TCA400SQLMetaData.getColumns(CatalogName, OwnerName, TableName, ColumnName: PWideChar; ColType: LongWord): SQLResult;
Const
	Columns: Array[0..13] Of WideString = ('RECNO', 'CATALOG_NAME', 'SCHEMA_NAME', 'TABLE_NAME', 'COLUMN_NAME', 'COLUMN_POSITION',
																		 'COLUMN_TYPE', 'COLUMN_DATATYPE', 'COLUMN_TYPENAME', 'COLUMN_SUBTYPE', 'COLUMN_LENGTH',
																		 'COLUMN_PRECISION', 'COLUMN_SCALE', 'COLUMN_NULLABLE');
Var
	Q: WideString;
begin
	Q:= 'select 1, '' '',dbilib,dbilfi,dbilfl,dbipos,'
		+ '0,0,dbityp,0,dbifln,'
		+ 'cast(dbinln as integer),cast(dbinsc as smallint), case dbinul when ''N'' then 0 else 1 end '
		+ 'from QSYS.QADBILFI where dbirel=''Y'' and dbiatr<>''IX''';
	AddQueryItem(Q, 'dbilib', ExpandSchemas(Unquote(OwnerName)));
	AddQueryItem(Q, 'dbilfi', Cite(UnQuote(TableName)));
	AddQueryItem(Q, 'dbilfl', Cite(UnQuote(ColumnName)));
	Result:= ExecuteQuery(Q, Columns);
end;

function TCA400SQLMetaData.getIndices(CatalogName, OwnerName, TableName: PWideChar; IndexType: LongWord): SQLResult;
Const
	Columns: Array[0..10] Of WideString = ('RECNO', 'CATALOG_NAME', 'SCHEMA_NAME', 'TABLE_NAME', 'INDEX_NAME', 'COLUMN_NAME',
																		 'COLUMN_POSITION', 'PKEY_NAME', 'INDEX_TYPE', 'SORT_ORDER', 'FILTER');
Var
	Q, QPrimary, InStr: WideString;
begin
	If (IndexType And eSQLPrimaryKey<>0) Or (IndexType=0) Then Begin
		QPrimary:= 'select 1,'' '',dbxlib,dbxlfi, ''PRIMARY'',dbilfl,integer(dbkpos),'' '','
			 + 'case dbxunq when ''D'' then 5 when ''U'' then 6 else 4 end,'
			 + 'dbkord, '' '' '
			 + 'from QSYS.QADBIATR, QSYS.QADBKATR, QSYS.QADBXATR '
			 + 'where dbxlib=dbilib and dbxfil=dbifil and dbilib=dbklib and dbifil=dbkfil and dbkfld=dbifld';
		AddQueryItem(QPrimary, 'dbxlib', ExpandSchemas(Unquote(OwnerName)));
		AddQueryItem(QPrimary, 'dbxlfi', Cite(Unquote(TableName)));
	End Else
		QPrimary:= '';

	InStr:= '';
	If (IndexType And eSQLUnique<>0) Or (IndexType=0) Then Begin
		AddInStr(InStr, Cite('U')); // Unique
		AddInStr(InStr, Cite('V')); // unique, Nullduplikate zulassen
	End;
	If (IndexType And eSQLNonUnique<>0) Or (IndexType=0) Then
		AddInStr(InStr, Cite('D'));
	Q:= 'select 1,'' '',dbxlib,dbxlfi,dbifil,dbilfl,integer(dbkpos),'' '','
		 + 'case dbxunq when ''D'' then 1 when ''U'' then 2 when ''V'' then 2 else 0 end,dbkord, '' '' '
		 + 'from QSYS.QADBIATR, QSYS.QADBKATR, QSYS.QADBXATR, QSYS.QADBLDEP '
		 + 'where dbxlib=dbflib and dbxfil=dbffil and dbfldp=dbilib and dbffdp=dbifil and dbilib=dbklib and dbifil=dbkfil and dbkfld=dbifld';
	AddQueryItem(Q, 'dbxlib', ExpandSchemas(Unquote(OwnerName)));
	AddQueryItem(Q, 'dbxlfi', Cite(Unquote(TableName)));
	AddQueryItem(Q, 'dbxunq', InStr);
	If QPrimary<>'' Then
		Q:= QPrimary+' union '+Q;
	Result:= ExecuteQuery(Q, Columns);
end;

function TCA400SQLMetaData.getObjectList(eObjType: TSQLObjectType): SQLResult;
begin
// yet not implemented:
//	eObjTypePackage
//	stUserNames
	Result:= DBXERR_NOTIMPLEMENT;
end;

function TCA400SQLMetaData.GetProcedures(CatalogName, OwnerName, ProcedureName: PWideChar; ProcType: LongWord): SQLResult;
Const
	Columns: Array[0..6] Of WideString =
		('RECNO', 'CATALOG_NAME', 'SCHEMA_NAME', 'PROC_NAME', 'PROC_TYPE',
		 'IN_PARAMS', 'OUT_PARAMS');
Var
	Q, InStr: WideString;
begin
	InStr:= '';
	If ProcType And (eSQLProcedure Or eSQLSysProcedure)<>0 Then
		AddInStr(InStr, Cite('PROCEDURE'));
	If ProcType And eSQLFunction<>0 Then
		AddInStr(InStr, Cite('FUNCTION'));
	Q:= 'select 1,'' '',specschema,specname,case rtntype when ''FUNCTION'' then 2 else 1 end,'
		+ 'in_parms,out_parms from QSYS2.SYSROUTINES';
	AddQueryItem(Q, 'rtntype', InStr);

	AddQueryItem(Q, 'specschema', ExpandSchemas(Unquote(OwnerName)));
	AddQueryItem(Q, 'specname', Cite(Unquote(ProcedureName)));

	Result:= ExecuteQuery(Q, Columns, Conn.FLIMITMD);
end;

Function TCA400SQLMetaData.GetProcedureParams(CatalogName, OwnerName, ProcName: PWideChar; ParamName: PWideChar): SQLResult;
Const
	Columns: Array[0..14] Of WideString = ('RECNO', 'CATALOG_NAME', 'SCHEMA_NAME', 'PROC_NAME', 'PARAM_NAME', 'PARAM_POSITION',
																				 'PARAM_TYPE', 'PARAM_DATATYPE', 'PARAM_TYPENAME', 'PARAM_SUBTYPE', 'PARAM_LENGTH',
																				 'PARAM_PRECISION', 'PARAM_SCALE', 'PARAM_NULLABLE', 'ORD');
Var
	Q: WideString;
begin
	// we have a special case: we want to limit retrieving to the procedure found FIRST in SchemaSpec
	Q:= 'select 1,'' '',p.specschema,p.specname,parmname,parmno,'
		+ 'case parmmode when ''IN'' then 1 when ''OUT'' then 2 else 3 end,0,data_type,0,'
		+ 'case when charlen is not null then charlen when data_type=''INTEGER'' then 4 when data_type=''SMALLINT'' then 2 when data_type=''BIGINT'' then 8 else precision end,'
		+ 'cast(precision as integer),cast(scale as smallint),case nulls when ''NO'' then 0 else 1 end, '
		+ 'cast('+CreateCase('p.specschema', ExpandSchemas(OwnerName))+' as integer) as ord '
		+ 'from QSYS2.SYSROUTINES s left outer join QSYS2.SYSPARMS p on s.specname=p.specname and s.specschema=p.specschema';
	AddQueryItem(Q, 's.specschema', ExpandSchemas(Unquote(OwnerName)));
	AddQueryItem(Q, 's.specname', Cite(Unquote(ProcName)));
	AddQueryItem(Q, 'parmname', Cite(Unquote(ParamName)));
	Q:= Q+' order by ord, parmno'; // so the first schema appears first
	Result:= ExecuteQuery(Q, Columns);
end;

Procedure TCA400SQLMetaData.AddQueryItem(Var Q: WideString; Tag: WideString; Value: WideString);
Begin
	Value:= Trim(Value);
	If Value='' Then
		Exit;
	If Pos(' where ', Q)=0 Then
		Q:= Q+' where '+Tag
	Else
		Q:= Q+' and '+Tag;
	If Pos(',', Value)>0 Then
		Q:= Q+Format(' in (%s)', [Value])
	Else
	If (Pos('%', Value)>0) Or (Pos('_', Value)>0) Then
		Q:= Q+' like '+Value
	Else
		Q:= Q+' = '+Value
End;

Procedure TCA400SQLMetaData.AddInStr (Var S: WideString; Const Value: WideString);
Begin
	If S='' Then
		S:= Value
	Else
		S:= S+','+Value
End;

Function TCA400SQLMetaData.CreateCase(Topic, Value: WideString): WideString;
// build "case Topic when 'AAA' then 1 when 'BBB' then 2.... else -1" from "'AAA', 'BBB'..."
Var
	i: Integer;
	List: TWideStrings;
Begin
	Result:= '';
	List:= TWideStringList.Create;
	Try
		List.CommaText:= Value;
		If List.Count>0 Then Begin
			For i:= 0 To List.Count-1 Do
				Result:= Format('%s when %s then %d', [Result, List[i], i+1]);
			Result:= Format('case %s %s else -1 end', [Topic, Result])
		End Else
			Result:= '-1'
	Finally
		List.Free
	End
End;

Function TCA400SQLMetaData.ExpandSchemas(Const Value: WideString): WideString;
Var
	i: Integer;
Begin
	If (Value='') Then Begin
		If Not Conn.FSystemNaming and (WMetaSchemaName<>'') Then
			Result:= Cite(WMetaSchemaName)
		Else
			If Conn.Libs.Count=0 Then Begin
				If Conn.WRole<>'' Then
					Result:= Cite(Conn.WRole)
				Else
					Result:= Cite(Conn.WUser)
			End Else Begin
				Result:= '';
				For i:= 0 To Conn.Libs.Count-1 Do
					AddInStr(Result, Cite(UpperCase(Conn.Libs[i])))
			End
	End Else
		Result:= Cite(Value)
End;

{ TCA400SQLMetaDataCursor }

destructor TCA400SQLMetaDataCursor.Destroy;
begin
	// Metadata Cursor frees it's SQL command
	FreeAndNil(FCommand);
	inherited;
end;

Procedure TCA400SQLMetaDataCursor.MapDataType (TypeName: WideString; Precision, Scale: Integer; Var DataType, SubType: Word);
// should match SetLogicalTypeInfo
Begin
	DataType:= fldUNKNOWN;
	SubType:= 0;
	If Pos('CHAR', TypeName)>0 Then Begin
		DataType:= fldZSTRING;
		If Pos('VAR', TypeName)=0 Then
			SubType:= fldstFIXED;
	End Else
	If Pos('INTEGER', TypeName)>0 Then DataType:= fldINT32 Else
	If Pos('SMALLINT', TypeName)>0 Then DataType:= fldINT16 Else
	If Pos('BIGINT', TypeName)>0 Then If Conn.FInt64AsBCD Then DataType:= fldBCD else DataType:= fldINT64 Else
	If Pos('REAL', TypeName)>0 Then DataType:= fldFLOAT Else
	If Pos('DOUBLE', TypeName)>0 Then DataType:= fldFLOAT Else
	If Pos('TIMEST', TypeName)>0 Then DataType:= fldDATETIME Else
	If Pos('TIME', TypeName)>0 Then DataType:= fldTIME Else
	If Pos('DATE', TypeName)>0 Then DataType:= fldDATE Else
	If Pos('DATALINK', TypeName)>0 Then DataType:= fldZSTRING Else
	If (Pos('DECIMAL', TypeName)>0)
	Or (Pos('NUMERIC', TypeName)>0) Then Begin
		If Conn.FMapFloat Then
			DataType:= fldFLOAT
		Else
			DataType:= fldBCD;
		If Scale=0 Then
			If Precision<10 Then
				DataType:= fldINT32
			Else
				DataType:= fldINT64
	End
End;

function TCA400SQLMetaDataCursor.getTypeSubType(Var DataType, SubType: Word; Var IsBlank: LongBool): SQLResult;
// added for BDP type mapping
Var
	TypeName: WideString;
	Precision: Integer;
	Scale: Word;
begin
	IsBlank:= True;
	Result:= DBXERR_NONE;
	If (FTypeNameColumn=0) Or (FDataTypeColumn=0) Or (FSubTypeColumn=0) Then
		Exit;
	SetLength(TypeName, 128);
	Result:= Inherited getWideString(FTypeNameColumn, PWideChar(TypeName), IsBlank);
	If (Result<>DBXERR_NONE) Or IsBlank Then Exit;
	SetLength(TypeName, WStrLen(PWideChar(TypeName)));
	TypeName:= Trim(TypeName);
	Precision:= 0;
	Scale:= 0;
	Result:= Inherited getLong(FPrecisionColumn, @Precision, IsBlank);
	If (Result<>DBXERR_NONE) Then Exit;
	Result:= Inherited getShort(FScaleColumn, @Scale, IsBlank);
	If (Result<>DBXERR_NONE) Then Exit;
	MapDataType(TypeName, Precision, Scale, DataType, SubType);
	IsBlank:= False
end;

function TCA400SQLMetaDataCursor.getLong(ColumnNumber: Word; Value: Pointer; var IsBlank: LongBool): SQLResult;
// modified for RECNO and data type mapping
Var
	TypeName: WideString;
	Precision: Integer;
	Scale: Word;
	DataType, SubType: Word;
begin
	If ColumnNumber=1 Then Begin
		Integer(Value^):= FRecNo;
		IsBlank:= False;
		Result:= DBXERR_NONE
	End Else
	If (FTypeNameColumn>0) And ((ColumnNumber=FDataTypeColumn) Or (ColumnNumber=FSubTypeColumn)) Then Begin
		SetLength(TypeName, 128);
		Result:= Inherited getWideString(FTypeNameColumn, PWideChar(TypeName), IsBlank);
		If (Result<>DBXERR_NONE) Or IsBlank Then Exit;
		SetLength(TypeName, WStrLen(PWideChar(TypeName)));
		TypeName:= Trim(TypeName);
		Precision:= 0;
		Scale:= 0;
		Result:= Inherited getLong(FPrecisionColumn, @Precision, IsBlank);
		If (Result<>DBXERR_NONE) Then Exit;
		Result:= Inherited getShort(FScaleColumn, @Scale, IsBlank);
		If (Result<>DBXERR_NONE) Then Exit;
		MapDataType(TypeName, Precision, Scale, DataType, SubType);
		If ColumnNumber=FDataTypeColumn Then
			Integer(Value^):= DataType
		Else
			Integer(Value^):= SubType;
		IsBlank:= False
	End Else
		Result:= Inherited getLong(ColumnNumber, Value, IsBlank)
end;

function TCA400SQLMetaDataCursor.getWideString(ColumnNumber: Word; Value: PWideChar; var IsBlank: LongBool): SQLResult;
// modified for quoting
Var
	Schema, Obj: WideString;
Begin
	If (FSchemaColumn>0) And (ColumnNumber=FObjColumn) Then Begin
		SetLength(Schema, 64);
		Result:= Inherited getWideString(FSchemaColumn, PWideChar(Schema), IsBlank);
		If Result<>DBXERR_NONE Then Exit;
		If IsBlank Then Schema:= '' Else SetLength(Schema, WStrLen(PWideChar(Schema)));
		Schema:= Trim(Schema);
		SetLength(Obj, 64);
		Result:= Inherited getWideString(ColumnNumber, PWideChar(Obj), IsBlank);
		If (Result<>DBXERR_NONE) Or IsBlank Then Exit;
		SetLength(Obj, WStrLen(PWideChar(Obj)));
		Obj:= Trim(Obj);
		If (Schema=WDefaultSchema) Or (Schema='') Then Begin
			If Conn.FFullQuoting Then
				Obj:= '"'+Obj+'"'
		End Else
			If Conn.FFullQuoting Then
				Obj:= '"'+Schema+'"'+Conn.Qualifier+'"'+Obj+'"'
			Else
				Obj:= Schema+Conn.Qualifier+Obj;
		WStrCopy(Value, PWideChar(Obj));
		IsBlank:= False
	End Else
		Result:= Inherited getWideString(ColumnNumber, Value, IsBlank)
End;

function TCA400SQLMetaDataCursor.getString(ColumnNumber: Word; Value: PChar; var IsBlank: LongBool): SQLResult;
// modified for quoting
Var
	Schema, Obj: WideString;
begin
	if (FSchemaColumn>0) and (ColumnNumber=FObjColumn) then
	begin
		SetLength(Schema, 64);
		Result:= Inherited getWideString(FSchemaColumn, PWideChar(Schema), IsBlank);
		If Result<>DBXERR_NONE Then Exit;
		If IsBlank Then Schema:= '' Else SetLength(Schema, WStrLen(PWideChar(Schema)));
		Schema:= Trim(Schema);
		SetLength(Obj, 64);
		Result:= Inherited getWideString(ColumnNumber, PWideChar(Obj), IsBlank);
		If (Result<>DBXERR_NONE) Or IsBlank Then Exit;
		SetLength(Obj, WStrLen(PWideChar(Obj)));
		Obj:= Trim(Obj);
		If (Schema=WDefaultSchema) Or (Schema='') Then Begin
			If Conn.FFullQuoting Then
				Obj:= '"'+Obj+'"'
		End Else
			If Conn.FFullQuoting Then
				Obj:= '"'+Schema+'"'+Conn.Qualifier+'"'+Obj+'"'
			Else
				Obj:= Schema+Conn.Qualifier+Obj;
		StrPCopy(Value, AnsiString(Obj));
		IsBlank:= False
	end
	else
		Result:= Inherited getString(ColumnNumber, Value, IsBlank)
end;

function TCA400SQLMetaDataCursor.next: SQLResult;
// modified for MAXREC
Var
	IsBlank: LongBool;
	CurOrd: Integer;
Begin
	Inc(FRecNo);
	If (FMaxRec>0) And (FRecNo>FMaxRec) Then
		Result:= DBXERR_EOF
	Else Begin
		Result:= Inherited Next;
		If (Result=DBXERR_NONE) And (FOrdColumn>0) Then Begin
			If FOrd=0 Then Begin // fetch first Ord
				getLong(FOrdColumn, @FOrd, IsBlank);
				If IsBlank Or (FOrd=-1) Then // this is for example the case if we have no proc params
					Result:= DBXERR_EOF
			End Else
				If (getLong(FOrdColumn, @CurOrd, IsBlank)=DBXERR_NONE) And (CurOrd<>FOrd) Then
					Result:= DBXERR_EOF
		End
	End
End;

// driver init function, exported. we use late binding so we do not bind to vendor lib

Function getSQLDriverCA400 (sVendorLib : PChar; sResourceFile : PChar; out Obj): SQLResult; StdCall;
begin
	try
		ISQLDriver(Obj):= TCA400SqlDriver.Create;
		Result:= DBXERR_NONE;
	except
		Result:= DBXERR_INVALIDHNDL
	end
end;

{$IfDef BuildForDLL}

// -------------------------------- BDP helpers ------------------------------------------------------
type
	THandleContainer = Class
	Private
		FList: TList;
		FLock: TRTLCriticalSection;
		Function Get(Index: Integer): TObject;
	Public
		Constructor Create;
		Destructor Destroy; Override;
		Function Add (Value: TObject): Integer;
		Procedure Remove (Value: Integer);
		Property Items[Index: Integer]: TObject Read Get; Default;
	End;

Var
	Connections: THandleContainer;
	Commands: THandleContainer;
	Cursors: THandleContainer;
	Metadata: THandleContainer;

Procedure Info (Value: String); Begin MessageBox(0, PChar(Value), 'Info', mb_Ok) End;

{ Helper }

Constructor THandleContainer.Create;
Begin
	Inherited Create;
	FList:= TList.Create;
	InitializeCriticalSection(FLock);
End;

Destructor THandleContainer.Destroy;
Begin
	FList.Free;
	DeleteCriticalSection(FLock);
	Inherited Destroy
End;

Function THandleContainer.Add (Value: TObject): Integer;
Var
	i: Integer;
Begin
	EnterCriticalSection(FLock);
	Try
		For i:= 0 To FList.Count-1 Do
			If FList[i] = Nil Then Begin
				FList[i]:= Pointer(Value);
				Result:= i;
				Exit
			End;
		Result:= FList.Add(Pointer(Value))
	Finally
		LeaveCriticalSection(FLock)
	End
End;

Procedure THandleContainer.Remove (Value: Integer);
Begin
	EnterCriticalSection(FLock);
	Try
		If (Value>=0) And (Value<FList.Count) Then
			FList[Value]:= Nil
	Finally
		LeaveCriticalSection(FLock)
	End
End;

Function THandleContainer.Get(Index: Integer): TObject;
Begin
	If (Index>=0) And (Index<FList.Count) Then
		Result:= TObject(FList[Index])
	Else
		Result:= Nil
End;

{ conversion }

Function DbxType(Value: Word): Word;
Begin
	Case Value Of
		0: Result:= fldUNKNOWN;
		1: Result:= fldZSTRING; 	 // String
		2: Result:= fldBOOL;			 // Boolean
		3: Result:= fldINT16; 		 // Int16
		4: Result:= fldINT32; 		 // Int32
		5: Result:= fldINT64; 		 // Int64
		6: Result:= fldFLOATIEEE;  // Float
		7: Result:= fldFLOAT; 		 // Double
		8: Result:= fldFMTBCD;		 // Decimal
		9: Result:= fldDATE;			 // Date
	 10: Result:= fldTIME;			 // Time
	 11: Result:= fldTIMESTAMP;  // DateTime
	 12: Result:= fldBYTES; 		 // Bytes
	 13: Result:= fldVARBYTES;	 // VarBytes
	 14: Result:= fldBLOB;			 // Blob
	 15: Result:= fldCURSOR;		 // Cursor
	 16: Result:= fldUNKNOWN; 	 // Guid
	 17: Result:= fldADT; 			 // Adt
	 18: Result:= fldARRAY; 		 // Array
	 19: Result:= fldREF; 			 // Ref
	 20: Result:= fldTABLE; 		 // Nested
 Else
	 Result:= fldUNKNOWN
 End
End;

Function DbxSubType(Value: Word): Word;
Begin
	Case Value Of
		51: Result:= fldstFIXED;
		52: Result:= fldstBINARY;
		53: Result:= fldstMEMO;
		54: Result:= fldstHBINARY;
		55: Result:= fldstHMEMO;
		56: Result:= fldstBFILE;
	Else
		Result:= 0
	End
End;

Function BdpType(Value: Word): Word;
Const
	MapType: Array[fldUNKNOWN..fldFMTBCD] Of Word = (0, 1, 9, 14, 2, 3, 4, 6, 8, 12, 10, 11, 3, 4, 6, 13, 0, 15, 5, 5, 17, 18, 19, 20, 11, 8);
Begin
	If {Value>=fldUNKNOWN And } (Value<=fldFMTBCD) Then
		Result:= MapType[Value]
	Else
		Result:= 0
End;

Function BdpSubType(Value: Word): Word;
Begin
	Case Value Of
		fldstFIXED: 	Result:= 51; // stFixed
		fldstBINARY:	Result:= 52; // stBinary
		fldstMEMO:		Result:= 53; // stMemo
		fldstHBINARY: Result:= 54; // stHBinary
		fldstHMEMO: 	Result:= 55; // stHMemo
		fldstBFILE: 	Result:= 56; // stBFile
	Else
		Result:= 0
	End
End;

{ Trace }


Function Trace(const Value: String): Boolean; Overload;
Begin
	Result:= True;
	OutputDebugString(PChar('bdpiSeries: '+Value));
end;

Function Trace(const Value: String; Items: array of Const): Boolean; Overload;
Begin
	Result:= Trace(Format(Value, Items))
End;


{ BdpConnection related }

function ConInit (szVendorLib: PChar; szResource: PChar): Integer; StdCall;
begin
	Result:= DBXERR_NONE
end;

function ConExit: Integer; StdCall;
begin
	Result:= DBXERR_NONE
end;

Function ConAlloc(Var Handle: Integer): Integer; StdCall;
Begin Try
	Handle:= Connections.Add(TCA400SQLConnection.Create(Nil));
	Assert(Trace('ConAlloc %d', [Handle]));
	Result:= DBXERR_NONE
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function ConFree(Handle: Integer): Integer; StdCall;
Begin Try
	Assert(Trace('ConFree %d', [Handle]));
	TCA400SQLConnection(Connections[Handle]).Free;
	Connections.Remove(Handle);
	Result:= DBXERR_NONE
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function ConConnect(Handle: Integer; szDatabase: PChar; szUser: PChar; szPasswd: PChar): Integer; StdCall;
var
	Conn: TCA400SQLConnection;
Begin Try
	Assert(Trace('ConConnect %d', [Handle]));
	Conn:= TCA400SQLConnection(Connections[Handle]);
	Conn.WUser:= szUser;
	Conn.WPassword:= szPasswd;
	Conn.WServerName:= szDatabase;
	Result:= Conn.Connect;
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function ConDisConnect(Handle: Integer): Integer; StdCall;
Begin Try
	Assert(Trace('ConDisConnect %d', [Handle]));
	Result:= TCA400SQLConnection(Connections[Handle]).Disconnect
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function ConSetOptions(Handle: Integer; szValue: PChar): Integer; StdCall;
Begin Try
	Assert(Trace('ConSetOptions %d=%s', [Handle, szValue]));
	TCA400SQLConnection(Connections[Handle]).ParseOptions(szValue);
	Result:= DBXERR_NONE;
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function ConTransact(Handle: Integer; Mode: Integer; ilTransID: Integer): Integer; StdCall;
Var
	Connection: TCA400SQLConnection;
	Trans: TTransactionDesc;
Begin Try
	Connection:= TCA400SQLConnection(Connections[Handle]);
	Trans.TransactionID:= ilTransID;
	Case Mode Of
		1: Result:= Connection.beginTransaction(LongWord(@Trans));
		2: Result:= Connection.Commit(LongWord(@Trans));
		4: Result:= Connection.Rollback(LongWord(@Trans));
	Else
		Result:= DBXERR_INVALIDTXNID
	End
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function ConGetConnError(Handle: Integer; Error: PChar; Len: Integer): Integer; StdCall;
Var
	Msg: WideString;
	MessageLen: SmallInt;
	Connection: TCA400SQLConnection;
Begin Try
	Connection:= TCA400SQLConnection(Connections[Handle]);
	Error[0]:= #0;
	Result:= Connection.getErrorMessageLen(MessageLen);
	if (Result = DBXERR_NONE) and (MessageLen > 0) then
	begin
		Msg:= Connection.getErrorMessage;
		StrLCopy(Error, PAnsiChar(AnsiString(Msg)), Len);
	end
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function ConGetCommand(Handle: Integer; Var Command: Integer): Integer; StdCall;
Begin Try
	Command:= Commands.Add(TCA400SQLCommand.Create(TCA400SQLConnection(Connections[Handle])));
	Assert(Trace('ConGetCommand %d -> %d', [Handle, Command]));
	Result:= DBXERR_NONE
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function ConGetMetadata(Handle: Integer; Var MetaHandle: Integer): Integer; StdCall;
Begin Try
	MetaHandle:= MetaData.Add(TCA400SQLMetaData.Create(TCA400SQLConnection(Connections[Handle])));
	Assert(Trace('ConGetMetadata %d -> %d', [Handle, MetaHandle]));
	Result:= DBXERR_NONE
Except
	Result:= DBXERR_INVALIDHNDL
End End;

{ BdpCommand related }

Function CmdSetOption (Handle: Integer; Option: Integer; ulValue: Integer): Integer; StdCall;
Var
	CmdOption: TSQLCommandOption;
Begin Try
	Case Option Of
		19: CmdOption:= eCommStoredProc;
	Else
Info('set unsupported SQLCommandOption');
		Result:= DBXERR_NOTSUPPORTED;
		Exit
	End;
	Result:= TCA400SQLCommand(Commands[Handle]).SetOption(CmdOption, ulValue);
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdPrepare (Handle: Integer; szSQL: PChar; ParamCount: Word; Var ColCount: Integer): Integer; StdCall;
Var
	Command: TCA400SQLCommand;
Begin Try
	Command:= TCA400SQLCommand(Commands[Handle]);
	Result:= Command.Prepare(szSQL, ParamCount);
	If Result=0 Then
		ColCount:= Command.ColumnCount
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdExecute (Handle: Integer; Var CursorHandle: Integer): Integer; StdCall;
Var
	Cursor: TCA400SQLCursor;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).Execute(Cursor);
	If Result=0 Then
		CursorHandle:= Cursors.Add(Cursor)
	Else
		CursorHandle:= -1
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdRowsAffected (Handle: Integer; Var RowsAffected: LongWord): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).getRowsAffected(RowsAffected)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdGetError(Handle: Integer; Error: PChar; Len: Integer): Integer; StdCall;
Var
	Msg: WideString;
	MessageLen: SmallInt;
	Command: TCA400SQLCommand;
Begin Try
	Command:= TCA400SQLCommand(Commands[Handle]);
	Error[0]:= #0;
	Result:= Command.getErrorMessageLen(MessageLen);
	if (Result = DBXERR_NONE) and (MessageLen > 0) then
	begin
		Msg:= Command.getErrorMessage;
		StrLCopy(Error, PAnsiChar(AnsiString(Msg)), Len);
	end
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdSetParameterInt16 (Handle: Integer; uParameter, uChildPos: Word; eParamDir: TSTMTParamType; uType, subType: Word; iPrecision, iScale: Integer; iLen: LongWord; Data: Word; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).SetParameter(uParameter+1, uChildPos, eParamDir, DbxType(uType), DbxSubType(subType), iPrecision, iScale, iLen, @Data, lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdSetParameterBool (Handle: Integer; uParameter, uChildPos: Word; eParamDir: TSTMTParamType; uType, subType: Word; iPrecision, iScale: Integer; iLen: LongWord; Data: LongBool; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).SetParameter(uParameter+1, uChildPos, eParamDir, DbxType(uType), DbxSubType(subType), iPrecision, iScale, iLen, @Data, lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdSetParameterInt32 (Handle: Integer; uParameter, uChildPos: Word; eParamDir: TSTMTParamType; uType, subType: Word; iPrecision, iScale: Integer; iLen: LongWord; Data: Integer; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).SetParameter(uParameter+1, uChildPos, eParamDir, DbxType(uType), DbxSubType(subType), iPrecision, iScale, iLen, @Data, lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdSetParameterInt64 (Handle: Integer; uParameter, uChildPos: Word; eParamDir: TSTMTParamType; uType, subType: Word; iPrecision, iScale: Integer; iLen: LongWord; Data: Int64; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).SetParameter(uParameter+1, uChildPos, eParamDir, DbxType(uType), DbxSubType(subType), iPrecision, iScale, iLen, @Data, lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdSetParameterFloat (Handle: Integer; uParameter, uChildPos: Word; eParamDir: TSTMTParamType; uType, subType: Word; iPrecision, iScale: Integer; iLen: LongWord; Data: Double; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).SetParameter(uParameter+1, uChildPos, eParamDir, DbxType(uType), DbxSubType(subType), iPrecision, iScale, iLen, @Data, lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdSetParameterDouble (Handle: Integer; uParameter, uChildPos: Word; eParamDir: TSTMTParamType; uType, subType: Word; iPrecision, iScale: Integer; iLen: LongWord; Data: Double; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).SetParameter(uParameter+1, uChildPos, eParamDir, DbxType(uType), DbxSubType(subType), iPrecision, iScale, iLen, @Data, lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdSetParameterString (Handle: Integer; uParameter, uChildPos: Word; eParamDir: TSTMTParamType; uType, subType: Word; iPrecision, iScale: Integer; iLen: LongWord; Data: PChar; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).SetParameter(uParameter+1, uChildPos, eParamDir, DbxType(uType), DbxSubType(subType), iPrecision, iScale, iLen, Data, lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdSetParameterDecimal (Handle: Integer; uParameter, uChildPos: Word; eParamDir: TSTMTParamType; uType, subType: Word; iPrecision, iScale: Integer; iLen: LongWord; Data: PChar; lInd: Integer): Integer; StdCall;
Var
	ABcd: TBcd;
Begin Try
	ABcd:= StrToBcd(Data);
	Result:= TCA400SQLCommand(Commands[Handle]).SetParameter(uParameter+1, uChildPos, eParamDir, DbxType(uType), DbxSubType(subType), iPrecision, iScale, iLen, @ABcd, lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdGetParameterInt16 (Handle: Integer; uParameter, uChildPos: Word; Var Data: Word; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).bdpGetParameter(uParameter+1, uChildPos, fldINT16, @Data, SizeOf(Data), lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdGetParameterBool (Handle: Integer; uParameter, uChildPos: Word; Var Data: LongBool; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).bdpGetParameter(uParameter+1, uChildPos, fldBOOL, @Data, SizeOf(Data), lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdGetParameterInt32 (Handle: Integer; uParameter, uChildPos: Word; Var Data: Integer; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).bdpGetParameter(uParameter+1, uChildPos, fldINT32, @Data, SizeOf(Data), lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdGetParameterInt64 (Handle: Integer; uParameter, uChildPos: Word; Var Data: Int64; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).bdpGetParameter(uParameter+1, uChildPos, fldINT64, @Data, SizeOf(Data), lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdGetParameterFloat (Handle: Integer; uParameter, uChildPos: Word; Var Data: Double; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).bdpGetParameter(uParameter+1, uChildPos, fldFLOAT, @Data, SizeOf(Data), lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdGetParameterDouble (Handle: Integer; uParameter, uChildPos: Word; Var Data: Double; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).bdpGetParameter(uParameter+1, uChildPos, fldFLOAT, @Data, SizeOf(Data), lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdGetParameterString (Handle: Integer; uParameter, uChildPos: Word; Data: PChar; Len: Integer; lInd: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).bdpGetParameter(uParameter+1, uChildPos, fldZSTRING, Data, Len, lInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CmdGetParameterDecimal (Handle: Integer; uParameter, uChildPos: Word; Data: PChar; Len: Integer; lInd: Integer): Integer; StdCall;
Var
	ABcd: TBcd;
Begin Try
	Result:= TCA400SQLCommand(Commands[Handle]).bdpGetParameter(uParameter+1, uChildPos, fldZSTRING, @ABcd, SizeOf(ABcd), lInd);
	If Result=0 Then
		StrLCopy(Data, PChar(BcdToStr(ABcd)), Len)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

{ BdpCursor related }

Function CurNext (Handle: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).Next
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetColumnName (Handle: Integer; ColumnNumber: Integer; Value: PChar; Len: Integer): Integer; StdCall;
Var
	Cursor: TCA400SQLCursor;
	Res: Word;
Begin Try
	Cursor:= TCA400SQLCursor(Cursors[Handle]);
	If Cursor.checkColumn(Res, ColumnNumber) Then
		StrLCopy(Value, PChar(String(Cursor.Cols[ColumnNumber-1].Name)), Len);
	Result:= Res;
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetColumnTypeName (Handle: Integer; ColumnNumber: Integer; Value: PChar; Len: Integer): Integer; StdCall;
Var
	Cursor: TCA400SQLCursor;
	Res: Word;
Begin Try
	Cursor:= TCA400SQLCursor(Cursors[Handle]);
	If Cursor.checkColumn(Res, ColumnNumber) Then
		StrLCopy(Value, PChar(String(Cursor.Cols[ColumnNumber-1].TypeName)), Len);
	Result:= Res;
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetColumnType (Handle: Integer; ColumnNumber: Integer; Var uType: Word; Var uSubType: Word): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).GetColumnType(ColumnNumber, uType, uSubType);
	If Result=0 Then Begin
		uType:= BdpType(uType);
		uSubType:= BdpSubType(uSubType)
	End
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetColumnLength (Handle: Integer; ColumnNumber: Integer; Var ulLength: LongWord): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).GetColumnLength(ColumnNumber, ulLength)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetIsNull (Handle: Integer; ColumnNumber: Integer; Var iInd: LongBool): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).isNullable(ColumnNumber, iInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetInt16 (Handle: Integer; ColumnNumber: Integer; Var Data: Word; Var iInd: LongBool): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).getShort(ColumnNumber, @Data, iInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetInt32 (Handle: Integer; ColumnNumber: Integer; Var Data: Integer; Var iInd: LongBool): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).getLong(ColumnNumber, @Data, iInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetInt64 (Handle: Integer; ColumnNumber: Integer; Var Data: Int64; Var iInd: LongBool): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).getInt64(ColumnNumber, @Data, iInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetDouble (Handle: Integer; ColumnNumber: Integer; Var Data: Double; Var iInd: LongBool): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).getDouble(ColumnNumber, @Data, iInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetFloat (Handle: Integer; ColumnNumber: Integer; Var Data: Double; Var iInd: LongBool): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).getDouble(ColumnNumber, @Data, iInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetString (Handle: Integer; ColumnNumber: Integer; Data: PChar; Var iInd: LongBool): Integer; StdCall;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).getString(ColumnNumber, Data, iInd)
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function CurGetDecimalAsString (Handle: Integer; ColumnNumber: Integer; Data: PChar; Var iInd: LongBool): Integer; StdCall;
Var
	ABcd: TBcd;
Begin Try
	Result:= TCA400SQLCursor(Cursors[Handle]).getBcd(ColumnNumber, @ABcd, iInd);
	If Result=0 Then
		StrCopy(Data, PChar(BcdToStr(ABcd)))
Except
	Result:= DBXERR_INVALIDHNDL
End End;

{ BdpMetadata related }

Function MetFree(Handle: Integer): Integer; StdCall;
Begin Try
	TCA400SQLMetaData(MetaData[Handle]).Free;
	MetaData.Remove(Handle);
	Result:= DBXERR_NONE
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function MetOpenSchema(Handle: Integer; eMetaDataType: Integer; CatalogName, OwnerName, ObjectName, ColName: PChar; ObjType: Integer): Integer; StdCall;
Var
	Meta: TCA400SQLMetaData;
	WCatalogName, WOwnerName, WObjectName, WColName: WideString;
Begin Try
	Assert(Trace('MetOpenSchema %d, Type=%d, Owner=%s, Object=%s, Col=%s', [Handle, eMetaDataType, OwnerName, ObjectName, ColName]));
	Meta:= TCA400SQLMetaData(MetaData[Handle]);
	WCatalogName:= CatalogName;
	WOwnerName:= OwnerName;
	WObjectName:= ObjectName;
	WColName:= ColName;
	Case eMetaDataType Of
		0: Result:= Meta.GetTables(PWideChar(WCatalogName), PWideChar(WOwnerName), PWideChar(WObjectName), ObjType);
		1: Result:= Meta.GetColumns(PWideChar(WCatalogName), PWideChar(WOwnerName), PWideChar(WObjectName), PWideChar(WColName), ObjType);
		2: Result:= Meta.GetProcedures(PWideChar(WCatalogName), PWideChar(WOwnerName), PWideChar(WObjectName), ObjType);
		3: Result:= Meta.GetProcedureParams(PWideChar(WCatalogName), PWideChar(WOwnerName), PWideChar(WObjectName), PWideChar(WColName));
		4,
		5: Result:= Meta.GetIndices(PWideChar(WCatalogName), PWideChar(WOwnerName), PWideChar(WObjectName), ObjType);
	Else
		Result:= DBXERR_INVALIDHNDL
	End;
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function MetCloseSchema(Handle: Integer): Integer; StdCall;
Begin Try
	TCA400SQLMetaData(MetaData[Handle]).MDCursor.Free;
	Result:= DBXERR_NONE
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function MetNext(Handle: Integer): Integer; StdCall;
Begin Try
	Result:= TCA400SQLMetaDataCursor(TCA400SQLMetaData(MetaData[Handle]).MDCursor).Next
Except
	Result:= DBXERR_EOF;
End End;

Function MetGetInt32 (Handle: Integer; ColumnNumber: Integer; Var Data: Integer; Var iInd: LongBool): Integer; StdCall;
Begin Try
	Result:= TCA400SQLMetaDataCursor(TCA400SQLMetaData(MetaData[Handle]).MDCursor).getLong(ColumnNumber, @Data, iInd);
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function MetGetString (Handle: Integer; ColumnNumber: Integer; Data: PChar; Var iInd: LongBool): Integer; StdCall;
Begin Try
	Result:= TCA400SQLMetaDataCursor(TCA400SQLMetaData(MetaData[Handle]).MDCursor).getString(ColumnNumber, Data, iInd);
	If (Result=DBXERR_NONE) and not (iInd) Then
		Data[Length(Trim(Data))]:= #0;
Except
	Result:= DBXERR_INVALIDHNDL
End End;

Function MetGetType (Handle: Integer; Var uType: Word; Var uSubType: Word; Var iInd: LongBool): Integer; StdCall;
Begin Try
	Result:= TCA400SQLMetaDataCursor(TCA400SQLMetaData(MetaData[Handle]).MDCursor).getTypeSubType(uType, uSubType, iInd);
	If (Result=DBXERR_NONE) and not (iInd) Then Begin
		uType:= BdpType(uType);
		uSubType:= BdpType(uSubType)
	End
Except
	Result:= DBXERR_INVALIDHNDL
End End;

// -------------------------------- end BDP helpers

Exports
	getSQLDriverCA400,

	// BDP helpers
	ConInit,
	ConExit,
	ConAlloc,
	ConFree,
	ConConnect,
	ConDisConnect,
	ConSetOptions,
	ConTransact,
	ConGetConnError,
	ConGetCommand,
	ConGetMetadata,

	CmdSetOption,
	CmdPrepare,
	CmdExecute,
	CmdRowsAffected,
	CmdGetError,
	CmdSetParameterBool,
	CmdSetParameterInt16,
	CmdSetParameterInt32,
	CmdSetParameterInt64,
	CmdSetParameterFloat,
	CmdSetParameterDouble,
	CmdSetParameterString,
	CmdSetParameterDecimal,
	CmdGetParameterBool,
	CmdGetParameterInt16,
	CmdGetParameterInt32,
	CmdGetParameterInt64,
	CmdGetParameterFloat,
	CmdGetParameterDouble,
	CmdGetParameterString,
	CmdGetParameterDecimal,

	CurNext,
	CurGetColumnName,
	CurGetColumnTypeName,
	CurGetColumnType,
	CurGetColumnLength,
	CurGetIsNull,
	CurGetInt16,
	CurGetInt32,
	CurGetInt64,
	CurGetDouble,
	CurGetFloat,
	CurGetString,
	CurGetDecimalAsString,

	MetFree,
	MetOpenSchema,
	MetCloseSchema,
	MetNext,
	MetGetInt32,
	MetGetString,
	MetGetType;

begin
	Connections:= THandleContainer.Create;
	Commands:= THandleContainer.Create;
	Cursors:= THandleContainer.Create;
	Metadata:= THandleContainer.Create;

{$Else}

Initialization
Begin
	SqlExpr.RegisterDbXpressLib(@getSQLDriverCA400);
End;

Finalization
Begin
End;
{$EndIf}

End.
